/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.obr.plugin.Config;
import org.apache.felix.obr.plugin.ObrUpdate;
import org.apache.felix.obr.plugin.PathFile;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class OBRInstall
extends AbstractMojo {
    private String obrRepository;
    private ArtifactRepository localRepository;
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        if ("NONE".equalsIgnoreCase(this.obrRepository)) {
            return;
        }
        Log log = this.getLog();
        try {
            String localRepoPath = this.localRepository.getBasedir();
            String artifactPath = this.localRepository.pathOf(this.project.getArtifact());
            String bundlePath = localRepoPath + File.separator + artifactPath;
            bundlePath = bundlePath.replace('\\', '/');
            PathFile repositoryXml = OBRInstall.normalizeRepositoryPath(this.obrRepository, localRepoPath);
            String extensionXml = OBRInstall.findOBRExtensions(this.project.getResources());
            Config user = new Config();
            ObrUpdate update = new ObrUpdate(repositoryXml, extensionXml, this.project, bundlePath, localRepoPath, user, log);
            repositoryXml.createPath();
            update.updateRepository();
        }
        catch (Exception e) {
            log.warn((CharSequence)("Exception while updating OBR: " + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private static PathFile normalizeRepositoryPath(String obrPath, String mavenPath) {
        URI uri;
        if (null == obrPath || obrPath.length() == 0) {
            obrPath = mavenPath + File.separatorChar + "repository.xml";
        } else if (!obrPath.endsWith(".xml")) {
            obrPath = obrPath + File.separatorChar + "repository.xml";
        }
        try {
            uri = new URI(obrPath);
        }
        catch (URISyntaxException e) {
            uri = null;
        }
        if (null == uri || !uri.isAbsolute()) {
            File file = new File(obrPath);
            if (!file.isAbsolute()) {
                file = new File(mavenPath, obrPath);
            }
            uri = file.toURI();
        }
        return new PathFile(uri.getScheme() + ':' + uri.getSchemeSpecificPart());
    }

    private static String findOBRExtensions(List resources) {
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            File obrFile = new File(resource.getDirectory(), "obr.xml");
            if (!obrFile.exists()) continue;
            return obrFile.getPath();
        }
        return null;
    }
}

