/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.FilterParserImpl;
import org.apache.directory.shared.ldap.filter.FilterVisitor;

public class BranchNormalizedVisitor
implements FilterVisitor {
    public void visit(ExprNode node) {
        if (!(node instanceof BranchNode)) {
            return;
        }
        BranchNode branch = (BranchNode)node;
        if (branch.getOperator() == 11) {
            return;
        }
        NodeComparator nodeComparator = new NodeComparator();
        TreeSet<ExprNode> set = new TreeSet<ExprNode>(nodeComparator);
        ArrayList children = branch.getChildren();
        for (int ii = 0; ii < children.size(); ++ii) {
            ExprNode child = (ExprNode)children.get(ii);
            if (!child.isLeaf()) {
                this.visit(child);
            }
            set.add(child);
        }
        children.clear();
        children.addAll(set);
    }

    public boolean canVisit(ExprNode node) {
        return node instanceof BranchNode;
    }

    public boolean isPrefix() {
        return false;
    }

    public ArrayList getOrder(BranchNode node, ArrayList children) {
        return children;
    }

    public static String getNormalizedFilter(String filter) throws IOException, ParseException {
        FilterParserImpl parser = new FilterParserImpl();
        ExprNode originalNode = parser.parse(filter);
        return BranchNormalizedVisitor.getNormalizedFilter(originalNode);
    }

    public static String getNormalizedFilter(ExprNode filter) {
        BranchNormalizedVisitor visitor = new BranchNormalizedVisitor();
        visitor.visit(filter);
        StringBuffer normalized = new StringBuffer();
        filter.printToBuffer(normalized);
        return normalized.toString().trim();
    }

    class NodeComparator
    implements Comparator {
        NodeComparator() {
        }

        public int compare(Object o1, Object o2) {
            StringBuffer buf = new StringBuffer();
            ExprNode n1 = (ExprNode)o1;
            ExprNode n2 = (ExprNode)o2;
            buf.setLength(0);
            String s1 = null;
            n1.printToBuffer(buf);
            s1 = buf.toString();
            buf.setLength(0);
            String s2 = null;
            n2.printToBuffer(buf);
            s2 = buf.toString();
            return s1.compareTo(s2);
        }
    }
}

