/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.changepw.service;

import org.apache.directory.server.changepw.messages.ChangePasswordRequest;
import org.apache.directory.server.changepw.service.ChangePasswordContext;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorRequest
implements IoHandlerCommand {
    private static final Logger log = LoggerFactory.getLogger((Class)MonitorRequest.class);
    private String contextKey = "context";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        if (log.isDebugEnabled()) {
            try {
                ChangePasswordContext changepwContext = (ChangePasswordContext)((Object)session.getAttribute(this.getContextKey()));
                ChangePasswordRequest request = (ChangePasswordRequest)changepwContext.getRequest();
                short authHeaderLength = request.getAuthHeaderLength();
                short messageLength = request.getMessageLength();
                short versionNumber = request.getVersionNumber();
                StringBuffer sb = new StringBuffer();
                sb.append("Responding to change password request:");
                sb.append("\n\tauthHeaderLength " + authHeaderLength);
                sb.append("\n\tmessageLength    " + messageLength);
                sb.append("\n\tversionNumber    " + versionNumber);
                log.debug(sb.toString());
            }
            catch (Exception e) {
                log.error("Error in request monitor", (Throwable)e);
            }
        }
        next.execute(session, message);
    }

    public String getContextKey() {
        return this.contextKey;
    }
}

