/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.AssertionBuilder;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Wss11;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSS11Builder
implements AssertionBuilder {
    private static final List<QName> KNOWN_ELEMENTS = Arrays.asList(SP11Constants.WSS11, SP12Constants.WSS11);
    PolicyBuilder builder;

    public WSS11Builder(PolicyBuilder b) {
        this.builder = b;
    }

    public PolicyAssertion build(Element element) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        Wss11 wss11 = new Wss11(consts);
        Policy policy = this.builder.getPolicy(DOMUtils.getFirstElement((Node)element));
        Iterator iterator = (policy = (Policy)policy.normalize(false)).getAlternatives();
        if (iterator.hasNext()) {
            this.processAlternative((List)iterator.next(), wss11, consts);
        }
        return wss11;
    }

    public List<QName> getKnownElements() {
        return KNOWN_ELEMENTS;
    }

    private void processAlternative(List assertions, Wss11 parent, SPConstants consts) {
        for (Assertion assertion : assertions) {
            QName name = assertion.getName();
            if (!consts.getNamespace().equals(name.getNamespaceURI())) continue;
            if ("MustSupportRefKeyIdentifier".equals(name.getLocalPart())) {
                parent.setMustSupportRefKeyIdentifier(true);
                continue;
            }
            if ("MustSupportRefIssuerSerial".equals(name.getLocalPart())) {
                parent.setMustSupportRefIssuerSerial(true);
                continue;
            }
            if ("MustSupportRefExternalURI".equals(name.getLocalPart())) {
                parent.setMustSupportRefExternalURI(true);
                continue;
            }
            if ("MustSupportRefEmbeddedToken".equals(name.getLocalPart())) {
                parent.setMustSupportRefEmbeddedToken(true);
                continue;
            }
            if ("MustSupportRefThumbprint".equals(name.getLocalPart())) {
                parent.setMustSupportRefThumbprint(true);
                continue;
            }
            if ("MustSupportRefEncryptedkey".equals(name.getLocalPart())) {
                parent.setMustSupportRefEncryptedKey(true);
                continue;
            }
            if (!"RequireSignatureConfirmation".equals(name.getLocalPart())) continue;
            parent.setRequireSignatureConfirmation(true);
        }
    }

    public PolicyAssertion buildCompatible(PolicyAssertion a, PolicyAssertion b) {
        return null;
    }
}

