/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.mail.internet.InternetHeaders;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.interceptor.AttachmentInputInterceptor;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageContextImpl
implements MessageContext {
    private Message m;

    public MessageContextImpl(Message m) {
        this.m = m;
    }

    @Override
    public Object get(Object key) {
        if ("org.apache.cxf.jaxrs.attachments.inbound".equals(key.toString())) {
            return this.createAttachments("org.apache.cxf.jaxrs.attachments.inbound");
        }
        return this.m.get(key);
    }

    @Override
    public <T> T getContent(Class<T> format) {
        return (T)this.m.getContent(format);
    }

    @Override
    public Object getContextualProperty(Object key) {
        return this.m.getContextualProperty(key.toString());
    }

    @Override
    public <T> T getContext(Class<T> contextClass) {
        return this.getContext(contextClass, contextClass);
    }

    protected <T> T getContext(Type genericType, Class<T> clazz) {
        return JAXRSUtils.createContextValue(this.m, genericType, clazz);
    }

    @Override
    public <T, E> T getResolver(Class<T> resolverClazz, Class<E> resolveClazz) {
        if (ContextResolver.class == resolverClazz) {
            return resolverClazz.cast(this.getContext(resolveClazz, ContextResolver.class));
        }
        return null;
    }

    @Override
    public Request getRequest() {
        return this.getContext(Request.class);
    }

    @Override
    public HttpHeaders getHttpHeaders() {
        return this.getContext(HttpHeaders.class);
    }

    @Override
    public Providers getProviders() {
        return this.getContext(Providers.class);
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.getContext(SecurityContext.class);
    }

    @Override
    public UriInfo getUriInfo() {
        return this.getContext(UriInfo.class);
    }

    @Override
    public HttpServletRequest getHttpServletRequest() {
        return JAXRSUtils.createServletResourceValue(this.m, HttpServletRequest.class);
    }

    @Override
    public HttpServletResponse getHttpServletResponse() {
        return JAXRSUtils.createServletResourceValue(this.m, HttpServletResponse.class);
    }

    @Override
    public ServletConfig getServletConfig() {
        return JAXRSUtils.createServletResourceValue(this.m, ServletConfig.class);
    }

    @Override
    public ServletContext getServletContext() {
        return JAXRSUtils.createServletResourceValue(this.m, ServletContext.class);
    }

    @Override
    public void put(Object key, Object value) {
        this.m.put((Object)key.toString(), value);
    }

    private MultipartBody createAttachments(String propertyName) {
        Object o = this.m.get((Object)propertyName);
        if (o != null) {
            return (MultipartBody)o;
        }
        new AttachmentInputInterceptor().handleMessage(this.m);
        LinkedList<Attachment> newAttachments = new LinkedList<Attachment>();
        try {
            Attachment first = new Attachment(AttachmentUtil.createAttachment((InputStream)((InputStream)this.m.getContent(InputStream.class)), (InternetHeaders)((InternetHeaders)this.m.get((Object)InternetHeaders.class.getName()))));
            newAttachments.add(first);
        }
        catch (IOException ex) {
            throw new WebApplicationException(500);
        }
        List<org.apache.cxf.message.Attachment> childAttachments = this.m.getAttachments();
        if (childAttachments == null) {
            childAttachments = Collections.emptyList();
        }
        childAttachments.size();
        for (org.apache.cxf.message.Attachment a : childAttachments) {
            newAttachments.add(new Attachment(a));
        }
        MultipartBody body = new MultipartBody(newAttachments, this.getHttpHeaders().getMediaType(), false);
        this.m.put((Object)propertyName, (Object)body);
        return body;
    }
}

