/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.databinding;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.aegis.AegisContext;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.databinding.ElementDataReader;
import org.apache.cxf.aegis.databinding.ElementDataWriter;
import org.apache.cxf.aegis.databinding.XMLStreamDataReader;
import org.apache.cxf.aegis.databinding.XMLStreamDataWriter;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.type.TypeClassInfo;
import org.apache.cxf.aegis.type.TypeCreationOptions;
import org.apache.cxf.aegis.type.TypeCreator;
import org.apache.cxf.aegis.type.TypeMapping;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.common.xmlschema.XmlSchemaUtils;
import org.apache.cxf.databinding.AbstractDataBinding;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.frontend.SimpleMethodDispatcher;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.AbstractMessageContainer;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaException;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AegisDatabinding
extends AbstractDataBinding {
    public static final String WRITE_XSI_TYPE_KEY = "writeXsiType";
    public static final String OVERRIDE_TYPES_KEY = "overrideTypesList";
    public static final String READ_XSI_TYPE_KEY = "readXsiType";
    protected static final int IN_PARAM = 0;
    protected static final int OUT_PARAM = 1;
    protected static final int FAULT_PARAM = 2;
    private static final Logger LOG = LogUtils.getL7dLogger(AegisDatabinding.class);
    private AegisContext aegisContext;
    private Map<MessagePartInfo, Type> part2Type = new HashMap<MessagePartInfo, Type>();
    private Service service;
    private boolean isInitialized;
    private Set<String> overrideTypes;
    private TypeCreationOptions configuration;
    private boolean mtomEnabled;
    private boolean mtomUseXmime;

    private void ensureInitialized() {
        if (!this.isInitialized) {
            if (this.aegisContext == null) {
                this.aegisContext = new AegisContext();
                if (this.overrideTypes != null) {
                    this.aegisContext.setRootClassNames(this.overrideTypes);
                }
                if (this.configuration != null) {
                    this.aegisContext.setTypeCreationOptions(this.configuration);
                }
                if (this.mtomEnabled) {
                    this.aegisContext.setMtomEnabled(true);
                }
                if (this.mtomUseXmime) {
                    this.aegisContext.setMtomUseXmime(true);
                }
                this.aegisContext.initialize();
            }
            this.isInitialized = true;
        }
    }

    public <T> DataReader<T> createReader(Class<T> cls) {
        this.ensureInitialized();
        if (cls.equals(XMLStreamReader.class)) {
            return new XMLStreamDataReader(this, this.getBus());
        }
        if (cls.equals(Node.class)) {
            return new ElementDataReader(this);
        }
        throw new UnsupportedOperationException();
    }

    public <T> DataWriter<T> createWriter(Class<T> cls) {
        this.ensureInitialized();
        if (cls.equals(XMLStreamWriter.class)) {
            return new XMLStreamDataWriter(this, this.getBus());
        }
        if (cls.equals(Node.class)) {
            return new ElementDataWriter(this);
        }
        throw new UnsupportedOperationException();
    }

    public Class<?>[] getSupportedReaderFormats() {
        return new Class[]{XMLStreamReader.class, Node.class};
    }

    public Class<?>[] getSupportedWriterFormats() {
        return new Class[]{XMLStreamWriter.class, Node.class};
    }

    public void initialize(Service s) {
        if (this.aegisContext == null) {
            this.aegisContext = new AegisContext();
            Object val = s.get((Object)READ_XSI_TYPE_KEY);
            if ("false".equals(val) || Boolean.FALSE.equals(val)) {
                this.aegisContext.setReadXsiTypes(false);
            }
            if ("true".equals(val = s.get((Object)WRITE_XSI_TYPE_KEY)) || Boolean.TRUE.equals(val)) {
                this.aegisContext.setWriteXsiTypes(true);
            }
            if ((val = s.get((Object)OVERRIDE_TYPES_KEY)) != null) {
                Collection nameCollection = (Collection)val;
                Collection typeNames = CastUtils.cast((Collection)nameCollection, String.class);
                if (this.overrideTypes == null) {
                    this.overrideTypes = new HashSet<String>();
                }
                this.overrideTypes.addAll(typeNames);
            }
            if ("true".equals(val = s.get((Object)"mtom-enabled")) || Boolean.TRUE.equals(val) || this.mtomEnabled) {
                this.aegisContext.setMtomEnabled(true);
            }
            if (this.mtomUseXmime) {
                this.aegisContext.setMtomUseXmime(true);
            }
            HashMap implMap = new HashMap();
            for (String key : s.keySet()) {
                if (!key.endsWith(".implementation")) continue;
                String className = key.substring(0, key.length() - ".implementation".length());
                Class clazz = null;
                try {
                    clazz = ClassLoaderUtils.loadClass((String)className, ((Object)((Object)this)).getClass());
                }
                catch (ClassNotFoundException e) {
                    Message message = new Message("MAPPED_CLASS_NOT_FOUND", LOG, new Object[]{className, key});
                    LOG.warning(message.toString());
                    continue;
                }
                String implClassName = (String)s.get((Object)key);
                implMap.put(clazz, implClassName);
            }
            if (this.overrideTypes != null) {
                this.aegisContext.setRootClassNames(this.overrideTypes);
            }
            if (this.configuration != null) {
                this.aegisContext.setTypeCreationOptions(this.configuration);
            }
            if (implMap.size() > 0) {
                this.aegisContext.setBeanImplementationMap(implMap);
            }
        }
        this.aegisContext.setMappingNamespaceURI(((ServiceInfo)s.getServiceInfos().get(0)).getName().getNamespaceURI());
        this.aegisContext.initialize();
        this.service = s;
        HashSet<Type> deps = new HashSet<Type>();
        for (ServiceInfo info : s.getServiceInfos()) {
            for (OperationInfo opInfo : info.getInterface().getOperations()) {
                if (opInfo.isUnwrappedCapable()) {
                    this.initializeOperation(s, this.aegisContext.getTypeMapping(), opInfo.getUnwrappedOperation(), deps);
                    continue;
                }
                this.initializeOperation(s, this.aegisContext.getTypeMapping(), opInfo, deps);
            }
        }
        Set<Type> additional = this.aegisContext.getRootTypes();
        if (additional != null) {
            for (Type t : additional) {
                if (!deps.contains(t)) {
                    deps.add(t);
                }
                this.addDependencies(deps, t);
            }
        }
        this.createSchemas(s, deps);
        for (ServiceInfo info : s.getServiceInfos()) {
            for (OperationInfo opInfo : info.getInterface().getOperations()) {
                if (opInfo.isUnwrappedCapable()) {
                    this.initializeOperationTypes(info, opInfo.getUnwrappedOperation());
                    continue;
                }
                this.initializeOperationTypes(info, opInfo);
            }
        }
    }

    private void initializeOperation(Service s, TypeMapping serviceTM, OperationInfo opInfo, Set<Type> deps) {
        try {
            this.initializeMessage(s, serviceTM, (AbstractMessageContainer)opInfo.getInput(), 0, deps);
            if (opInfo.hasOutput()) {
                this.initializeMessage(s, serviceTM, (AbstractMessageContainer)opInfo.getOutput(), 1, deps);
            }
            for (FaultInfo info : opInfo.getFaults()) {
                this.initializeMessage(s, serviceTM, (AbstractMessageContainer)info, 2, deps);
            }
        }
        catch (DatabindingException e) {
            e.prepend("Error initializing parameters for operation " + opInfo.getName());
            throw e;
        }
    }

    private void initializeOperationTypes(ServiceInfo s, OperationInfo opInfo) {
        try {
            this.initializeMessageTypes(s, (AbstractMessageContainer)opInfo.getInput(), 0);
            if (opInfo.hasOutput()) {
                this.initializeMessageTypes(s, (AbstractMessageContainer)opInfo.getOutput(), 1);
            }
            for (FaultInfo info : opInfo.getFaults()) {
                this.initializeMessageTypes(s, (AbstractMessageContainer)info, 2);
            }
        }
        catch (DatabindingException e) {
            e.prepend("Error initializing parameters for operation " + opInfo.getName());
            throw e;
        }
    }

    protected void initializeMessage(Service s, TypeMapping serviceTM, AbstractMessageContainer container, int partType, Set<Type> deps) {
        if (container == null) {
            return;
        }
        for (MessagePartInfo part : container.getMessageParts()) {
            long mo;
            long miValue;
            Type type = this.getParameterType(s, serviceTM, part, partType);
            if (part.getXmlSchema() == null) {
                if (type.isAbstract()) {
                    part.setTypeQName(type.getSchemaType());
                } else {
                    part.setElementQName(type.getSchemaType());
                }
            }
            if (part.getProperty("nillable") == null) {
                part.setProperty("nillable", (Object)type.isNillable());
            }
            if (type.hasMinOccurs() && (miValue = type.getMinOccurs()) != 0L) {
                part.setProperty("minOccurs", (Object)Long.toString(miValue));
            }
            if (type.hasMaxOccurs() && (mo = type.getMaxOccurs()) != Long.MAX_VALUE) {
                String moValue = Long.toString(mo);
                part.setProperty("maxOccurs", (Object)moValue);
            }
            this.part2Type.put(part, type);
            deps.add(type);
            this.addDependencies(deps, type);
        }
    }

    protected void initializeMessageTypes(ServiceInfo s, AbstractMessageContainer container, int partType) {
        if (container == null) {
            return;
        }
        SchemaCollection col = s.getXmlSchemaCollection();
        for (MessagePartInfo part : container.getMessageParts()) {
            XmlSchemaElement tp;
            if (part.getXmlSchema() != null) continue;
            if (part.isElement()) {
                tp = col.getElementByQName(part.getElementQName());
                part.setXmlSchema((XmlSchemaAnnotated)tp);
                continue;
            }
            tp = col.getTypeByQName(part.getTypeQName());
            part.setXmlSchema((XmlSchemaAnnotated)tp);
        }
    }

    private void addDependencies(Set<Type> deps, Type type) {
        Set<Type> typeDeps = type.getDependencies();
        if (typeDeps != null) {
            for (Type t : typeDeps) {
                if (deps.contains(t)) continue;
                deps.add(t);
                this.addDependencies(deps, t);
            }
        }
    }

    private void createSchemas(Service s, Set<Type> deps) {
        HashMap<String, HashSet<Type>> tns2Type = new HashMap<String, HashSet<Type>>();
        for (Type t : deps) {
            String ns = t.getSchemaType().getNamespaceURI();
            HashSet<Type> types = (HashSet<Type>)tns2Type.get(ns);
            if (types == null) {
                types = new HashSet<Type>();
                tns2Type.put(ns, types);
            }
            types.add(t);
        }
        for (ServiceInfo si : s.getServiceInfos()) {
            SchemaCollection col = si.getXmlSchemaCollection();
            if (col.getXmlSchemas().length <= 1) continue;
        }
        Map namespaceMap = this.getDeclaredNamespaceMappings();
        for (ServiceInfo si : s.getServiceInfos()) {
            SchemaInfo schemaInfo;
            XmlSchema schema;
            boolean needXmimeSchema = false;
            boolean needTypesSchema = false;
            for (Map.Entry entry : tns2Type.entrySet()) {
                String schemaNamespaceUri = (String)entry.getKey();
                if ("http://www.w3.org/2001/XMLSchema".equals(schemaNamespaceUri) || "http://cxf.apache.org/aegisTypes".equals(schemaNamespaceUri) || "http://www.w3.org/2005/05/xmlmime".equals(schemaNamespaceUri)) continue;
                SchemaInfo schemaInfo2 = si.addNewSchema((String)entry.getKey());
                XmlSchema schema2 = schemaInfo2.getSchema();
                NamespaceMap xmlsNamespaceMap = new NamespaceMap();
                if (namespaceMap != null) {
                    for (Map.Entry e : namespaceMap.entrySet()) {
                        xmlsNamespaceMap.add((String)e.getValue(), (String)e.getKey());
                    }
                }
                if (!xmlsNamespaceMap.containsKey((Object)"tns") && !xmlsNamespaceMap.containsValue(entry.getKey())) {
                    xmlsNamespaceMap.add("tns", (String)entry.getKey());
                }
                if (!xmlsNamespaceMap.containsKey((Object)"xsd") && !xmlsNamespaceMap.containsValue((Object)"http://www.w3.org/2001/XMLSchema")) {
                    xmlsNamespaceMap.add("xsd", "http://www.w3.org/2001/XMLSchema");
                }
                schema2.setNamespaceContext((NamespacePrefixList)xmlsNamespaceMap);
                schema2.setTargetNamespace((String)entry.getKey());
                schema2.setElementFormDefault(new XmlSchemaForm("qualified"));
                schema2.setAttributeFormDefault(new XmlSchemaForm("qualified"));
                for (Type t : (Set)entry.getValue()) {
                    try {
                        t.writeSchema(schema2);
                    }
                    catch (XmlSchemaException ex) {
                        QName name = t.getSchemaType();
                        String expected = " Schema for namespace '" + name.getNamespaceURI() + "' already contains type '" + name.getLocalPart() + "'";
                        String message = ex.getMessage();
                        if (expected.equals(message)) continue;
                        throw ex;
                    }
                }
                if (this.schemaImportsXmime(schema2)) {
                    needXmimeSchema = true;
                }
                if (!AegisContext.schemaImportsUtilityTypes(schema2)) continue;
                needTypesSchema = true;
            }
            if (needXmimeSchema) {
                schema = this.aegisContext.addXmimeSchemaDocument(si.getXmlSchemaCollection().getXmlSchemaCollection());
                schemaInfo = new SchemaInfo(schema.getTargetNamespace());
                schemaInfo.setSchema(schema);
                si.addSchema(schemaInfo);
            }
            if (needTypesSchema) {
                schema = this.aegisContext.addTypesSchemaDocument(si.getXmlSchemaCollection().getXmlSchemaCollection());
                schemaInfo = new SchemaInfo(schema.getTargetNamespace());
                schemaInfo.setSchema(schema);
                si.addSchema(schemaInfo);
            }
            si.getXmlSchemaCollection().addCrossImports();
        }
    }

    private boolean schemaImportsXmime(XmlSchema schema) {
        return XmlSchemaUtils.schemaImportsNamespace((XmlSchema)schema, (String)"http://www.w3.org/2005/05/xmlmime");
    }

    public QName getSuggestedName(Service s, TypeMapping tm, OperationInfo op, int param) {
        Type type;
        Method m = this.getMethod(s, op);
        if (m == null) {
            return null;
        }
        QName name = tm.getTypeCreator().getElementName(m, param);
        if (name == null && (type = tm.getTypeCreator().createType(m, param)).isComplex() && !type.isAbstract()) {
            name = type.getSchemaType();
        }
        return name;
    }

    private Type getParameterType(Service s, TypeMapping tm, MessagePartInfo param, int paramtype) {
        Type type = tm.getType(param.getTypeQName());
        int offset = 0;
        if (paramtype == 1) {
            offset = 1;
        }
        TypeCreator typeCreator = tm.getTypeCreator();
        if (type == null) {
            OperationInfo op = param.getMessageInfo().getOperation();
            Method m = this.getMethod(s, op);
            TypeClassInfo info = paramtype != 2 && m != null ? typeCreator.createClassInfo(m, param.getIndex() - offset) : typeCreator.createBasicClassInfo(param.getTypeClass());
            Boolean nillable = info.getNillable();
            if (param.getMessageInfo().getOperation().isUnwrapped() && param.getTypeClass().isArray()) {
                param.setProperty("minOccurs", (Object)"1");
                param.setProperty("maxOccurs", (Object)"1");
                if (nillable == null) {
                    nillable = Boolean.TRUE;
                }
                param.setProperty("nillable", (Object)nillable);
            } else {
                if (nillable != null) {
                    param.setProperty("nillable", (Object)nillable);
                }
                if (info.getMinOccurs() != -1L) {
                    param.setProperty("minOccurs", (Object)Long.toString(info.getMinOccurs()));
                }
                if (info.getMaxOccurs() != -1L) {
                    param.setProperty("maxOccurs", (Object)Long.toString(info.getMaxOccurs()));
                }
            }
            if (info.getMappedName() != null) {
                param.setConcreteName(info.getMappedName());
                param.setName(info.getMappedName());
            }
            type = typeCreator.createTypeForClass(info);
            if (info.nonDefaultAttributes()) {
                tm.register(type);
            }
            type.setTypeMapping(tm);
            this.part2Type.put(param, type);
        }
        return type;
    }

    private Method getMethod(Service s, OperationInfo op) {
        MethodDispatcher md = (MethodDispatcher)s.get((Object)MethodDispatcher.class.getName());
        if (md == null) {
            return null;
        }
        SimpleMethodDispatcher smd = (SimpleMethodDispatcher)md;
        return smd != null ? smd.getPrimaryMethod(op) : null;
    }

    public Type getType(MessagePartInfo part) {
        return this.part2Type.get(part);
    }

    public MessagePartInfo getPartFromClass(Class<?> cls) {
        for (Map.Entry<MessagePartInfo, Type> entry : this.part2Type.entrySet()) {
            if (entry.getValue().getTypeClass() != cls) continue;
            return entry.getKey();
        }
        return null;
    }

    public Type getTypeFromClass(Class<?> cls) {
        for (Type t : this.part2Type.values()) {
            if (t.getTypeClass() != cls) continue;
            return t;
        }
        return null;
    }

    public Service getService() {
        return this.service;
    }

    public AegisContext getAegisContext() {
        this.ensureInitialized();
        return this.aegisContext;
    }

    public void setAegisContext(AegisContext aegisContext) {
        this.aegisContext = aegisContext;
    }

    public void setOverrideTypes(Set<String> types) {
        this.overrideTypes = types;
    }

    public void setConfiguration(TypeCreationOptions configuration) {
        this.configuration = configuration;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public boolean isMtomUseXmime() {
        return this.mtomUseXmime;
    }

    public void setMtomUseXmime(boolean mtomUseXmime) {
        this.mtomUseXmime = mtomUseXmime;
    }
}

