/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import org.apache.commons.imaging.formats.tiff.TiffRasterData;
import org.apache.commons.imaging.formats.tiff.TiffRasterDataType;
import org.apache.commons.imaging.formats.tiff.TiffRasterStatistics;

public class TiffRasterDataInt
extends TiffRasterData {
    private final int[] data;

    public TiffRasterDataInt(int width, int height) {
        super(width, height, 1);
        this.data = new int[this.nCells];
    }

    public TiffRasterDataInt(int width, int height, int samplesPerPixel) {
        super(width, height, samplesPerPixel);
        this.data = new int[this.nCells];
    }

    public TiffRasterDataInt(int width, int height, int[] data) {
        super(width, height, 1);
        if (data == null || data.length < this.nCells) {
            throw new IllegalArgumentException("Specified data does not contain sufficient elements");
        }
        this.data = data;
    }

    public TiffRasterDataInt(int width, int height, int samplesPerPixel, int[] data) {
        super(width, height, samplesPerPixel);
        if (data == null || data.length < this.nCells) {
            throw new IllegalArgumentException("Specified data does not contain sufficient elements");
        }
        this.data = data;
    }

    @Override
    public TiffRasterDataType getDataType() {
        return TiffRasterDataType.INTEGER;
    }

    @Override
    public void setValue(int x, int y, float value) {
        int index = this.checkCoordinatesAndComputeIndex(x, y, 0);
        this.data[index] = (int)value;
    }

    @Override
    public void setValue(int x, int y, int i, float value) {
        int index = this.checkCoordinatesAndComputeIndex(x, y, i);
        this.data[index] = (int)value;
    }

    @Override
    public float getValue(int x, int y) {
        int index = this.checkCoordinatesAndComputeIndex(x, y, 0);
        return this.data[index];
    }

    @Override
    public float getValue(int x, int y, int i) {
        int index = this.checkCoordinatesAndComputeIndex(x, y, i);
        return this.data[index];
    }

    @Override
    public void setIntValue(int x, int y, int value) {
        int index = this.checkCoordinatesAndComputeIndex(x, y, 0);
        this.data[index] = value;
    }

    @Override
    public void setIntValue(int x, int y, int i, int value) {
        int index = this.checkCoordinatesAndComputeIndex(x, y, i);
        this.data[index] = value;
    }

    @Override
    public int getIntValue(int x, int y) {
        int index = this.checkCoordinatesAndComputeIndex(x, y, 0);
        return this.data[index];
    }

    @Override
    public int getIntValue(int x, int y, int i) {
        int index = this.checkCoordinatesAndComputeIndex(x, y, i);
        return this.data[index];
    }

    @Override
    public TiffRasterStatistics getSimpleStatistics() {
        return new TiffRasterStatistics(this, Float.NaN);
    }

    @Override
    public TiffRasterStatistics getSimpleStatistics(float valueToExclude) {
        return new TiffRasterStatistics(this, valueToExclude);
    }

    @Override
    public int[] getIntData() {
        return this.data;
    }

    @Override
    public float[] getData() {
        float[] result = new float[this.nCells];
        for (int i = 0; i < this.nCells; ++i) {
            result[i] = this.data[i];
        }
        return result;
    }
}

