/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.spring.configurator.logback;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.util.StatusPrinter;
import org.apache.cocoon.configuration.Settings;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class LogbackConfigurator
extends JoranConfigurator
implements InitializingBean {
    protected Settings settings;
    protected Resource resource;

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void afterPropertiesSet() throws Exception {
        LoggerContext loggerCtx = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.setContext((Context)loggerCtx);
        loggerCtx.reset();
        this.getContext().putProperty("org.apache.cocoon.cache.directory", this.settings.getCacheDirectory());
        this.getContext().putProperty("org.apache.cocoon.containerencoding", this.settings.getContainerEncoding());
        this.getContext().putProperty("org.apache.cocoon.formencoding", this.settings.getFormEncoding());
        this.getContext().putProperty("org.apache.cocoon.work.directory", this.settings.getWorkDirectory());
        for (Object propName : this.settings.getPropertyNames()) {
            this.getContext().putProperty((String)propName, this.settings.getProperty((String)propName));
        }
        this.doConfigure(this.resource.getURL());
        StatusPrinter.print((Context)loggerCtx);
    }
}

