/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.atompub;

import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.Base64;
import org.apache.chemistry.opencmis.commons.impl.JaxBHelper;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisProperty;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertyString;

public class AtomEntryWriter {
    private static final String PREFIX_ATOM = "atom";
    private static final String PREFIX_CMIS = "cmis";
    private static final String PREFIX_RESTATOM = "cmisra";
    private static final int BUFFER_SIZE = 65536;
    private CmisObjectType object;
    private InputStream stream;
    private String mediaType;

    public AtomEntryWriter(CmisObjectType object) {
        this(object, null, null);
    }

    public AtomEntryWriter(CmisObjectType object, String mediaType, InputStream stream) {
        if (object == null || object.getProperties() == null) {
            throw new CmisInvalidArgumentException("Object and properties must not be null!");
        }
        if (stream != null && mediaType == null) {
            throw new CmisInvalidArgumentException("Media type must be set if a stream is present!");
        }
        this.object = object;
        this.mediaType = mediaType;
        this.stream = stream;
    }

    public void write(OutputStream out) throws Exception {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = factory.createXMLStreamWriter(out, "UTF-8");
        writer.setPrefix(PREFIX_ATOM, "http://www.w3.org/2005/Atom");
        writer.setPrefix(PREFIX_CMIS, "http://docs.oasis-open.org/ns/cmis/core/200908/");
        writer.setPrefix(PREFIX_RESTATOM, "http://docs.oasis-open.org/ns/cmis/restatom/200908/");
        writer.writeStartDocument();
        writer.writeStartElement("http://www.w3.org/2005/Atom", "entry");
        writer.writeNamespace(PREFIX_ATOM, "http://www.w3.org/2005/Atom");
        writer.writeNamespace(PREFIX_CMIS, "http://docs.oasis-open.org/ns/cmis/core/200908/");
        writer.writeNamespace(PREFIX_RESTATOM, "http://docs.oasis-open.org/ns/cmis/restatom/200908/");
        writer.writeStartElement("http://www.w3.org/2005/Atom", "id");
        writer.writeCharacters("urn:uuid:00000000-0000-0000-0000-00000000000");
        writer.writeEndElement();
        writer.writeStartElement("http://www.w3.org/2005/Atom", "title");
        writer.writeCharacters(this.getTitle());
        writer.writeEndElement();
        writer.writeStartElement("http://www.w3.org/2005/Atom", "updated");
        writer.writeCharacters(AtomEntryWriter.getUpdated());
        writer.writeEndElement();
        if (this.stream != null) {
            writer.writeStartElement("http://docs.oasis-open.org/ns/cmis/restatom/200908/", "content");
            writer.writeStartElement("http://docs.oasis-open.org/ns/cmis/restatom/200908/", "mediatype");
            writer.writeCharacters(this.mediaType);
            writer.writeEndElement();
            writer.writeStartElement("http://docs.oasis-open.org/ns/cmis/restatom/200908/", "base64");
            this.writeContent(writer);
            writer.writeEndElement();
            writer.writeEndElement();
        }
        JaxBHelper.marshal((Object)JaxBHelper.CMIS_EXTRA_OBJECT_FACTORY.createObject(this.object), (XMLStreamWriter)writer, (boolean)true);
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
    }

    private String getTitle() {
        String result = "";
        for (CmisProperty property : this.object.getProperties().getProperty()) {
            List values;
            if (!"cmis:name".equals(property.getPropertyDefinitionId()) || !(property instanceof CmisPropertyString) || (values = ((CmisPropertyString)property).getValue()).isEmpty()) continue;
            return (String)values.get(0);
        }
        return result;
    }

    private static String getUpdated() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(new Date());
    }

    private void writeContent(XMLStreamWriter writer) throws Exception {
        int b;
        Base64.InputStream b64stream = new Base64.InputStream(this.stream, 1);
        byte[] buffer = new byte[65536];
        while ((b = b64stream.read(buffer)) > -1) {
            if (b <= 0) continue;
            writer.writeCharacters(new String(buffer, 0, b, "US-ASCII"));
        }
    }
}

