/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.atompub;

import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.AtomPubParser;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.HttpUtils;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.LinkAccess;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.LinkCache;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomAcl;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomBase;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomElement;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomEntry;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomLink;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.RepositoryWorkspace;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.ServiceDoc;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Principal;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisFilterNotValidException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNameConstraintViolationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisProxyAuthenticationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStreamNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisVersioningException;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.JaxBHelper;
import org.apache.chemistry.opencmis.commons.impl.ReturnVersion;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlEntryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlPrincipalDataImpl;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisAccessControlListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertiesType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertyId;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisRepositoryInfoType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractAtomPubService
implements LinkAccess {
    protected static final String NAME_COLLECTION = "collection";
    protected static final String NAME_URI_TEMPLATE = "uritemplate";
    protected static final String NAME_PATH_SEGMENT = "pathSegment";
    protected static final String NAME_RELATIVE_PATH_SEGMENT = "relativePathSegment";
    protected static final String NAME_NUM_ITEMS = "numItems";
    private BindingSession session;

    protected void setSession(BindingSession session) {
        this.session = session;
    }

    protected BindingSession getSession() {
        return this.session;
    }

    protected String getServiceDocURL() {
        Object url = this.session.get("org.apache.chemistry.opencmis.binding.atompub.url");
        if (url instanceof String) {
            return (String)url;
        }
        return null;
    }

    protected LinkCache getLinkCache() {
        LinkCache linkCache = (LinkCache)this.getSession().get("org.apache.chemistry.opencmis.binding.atompub.linkcache");
        if (linkCache == null) {
            linkCache = new LinkCache(this.getSession());
            this.getSession().put("org.apache.chemistry.opencmis.binding.atompub.linkcache", linkCache);
        }
        return linkCache;
    }

    protected String getLink(String repositoryId, String id, String rel, String type) {
        if (repositoryId == null) {
            throw new CmisInvalidArgumentException("Repository id must be set!");
        }
        if (id == null) {
            throw new CmisInvalidArgumentException("Object id must be set!");
        }
        return this.getLinkCache().getLink(repositoryId, id, rel, type);
    }

    protected String getLink(String repositoryId, String id, String rel) {
        return this.getLink(repositoryId, id, rel, null);
    }

    @Override
    public String loadLink(String repositoryId, String id, String rel, String type) {
        String link = this.getLink(repositoryId, id, rel, type);
        if (link == null) {
            this.getObjectInternal(repositoryId, IdentifierType.ID, id, ReturnVersion.THIS, null, null, null, null, null, null, null);
            link = this.getLink(repositoryId, id, rel, type);
        }
        return link;
    }

    @Override
    public String loadContentLink(String repositoryId, String id) {
        return this.loadLink(repositoryId, id, "@@content@@", null);
    }

    protected void addLink(String repositoryId, String id, String rel, String type, String link) {
        this.getLinkCache().addLink(repositoryId, id, rel, type, link);
    }

    protected void addLink(String repositoryId, String id, AtomLink link) {
        this.getLinkCache().addLink(repositoryId, id, link.getRel(), link.getType(), link.getHref());
    }

    protected void removeLinks(String repositoryId, String id) {
        this.getLinkCache().removeLinks(repositoryId, id);
    }

    protected void lockLinks() {
        this.getLinkCache().lockLinks();
    }

    protected void unlockLinks() {
        this.getLinkCache().unlockLinks();
    }

    protected void throwLinkException(String repositoryId, String id, String rel, String type) {
        int index = this.getLinkCache().checkLink(repositoryId, id, rel, type);
        switch (index) {
            case 0: {
                throw new CmisObjectNotFoundException("Unknown repository!");
            }
            case 1: {
                throw new CmisObjectNotFoundException("Unknown object!");
            }
            case 2: {
                throw new CmisNotSupportedException("Operation not supported by the repository for this object!");
            }
            case 3: {
                throw new CmisNotSupportedException("No link with matching media type!");
            }
            case 4: {
                throw new CmisRuntimeException("Nothing wrong! Either this is a bug or threading issue.");
            }
        }
        throw new CmisRuntimeException("Unknown error!");
    }

    protected String getTypeLink(String repositoryId, String typeId, String rel, String type) {
        if (repositoryId == null) {
            throw new CmisInvalidArgumentException("Repository id must be set!");
        }
        if (typeId == null) {
            throw new CmisInvalidArgumentException("Type id must be set!");
        }
        return this.getLinkCache().getTypeLink(repositoryId, typeId, rel, type);
    }

    protected String getTypeLink(String repositoryId, String typeId, String rel) {
        return this.getTypeLink(repositoryId, typeId, rel, null);
    }

    protected String loadTypeLink(String repositoryId, String typeId, String rel, String type) {
        String link = this.getTypeLink(repositoryId, typeId, rel, type);
        if (link == null) {
            this.getTypeDefinitionInternal(repositoryId, typeId);
            link = this.getTypeLink(repositoryId, typeId, rel, type);
        }
        return link;
    }

    protected void addTypeLink(String repositoryId, String typeId, String rel, String type, String link) {
        this.getLinkCache().addTypeLink(repositoryId, typeId, rel, type, link);
    }

    protected void addTypeLink(String repositoryId, String typeId, AtomLink link) {
        this.getLinkCache().addTypeLink(repositoryId, typeId, link.getRel(), link.getType(), link.getHref());
    }

    protected void removeTypeLinks(String repositoryId, String id) {
        this.getLinkCache().removeTypeLinks(repositoryId, id);
    }

    protected void lockTypeLinks() {
        this.getLinkCache().lockTypeLinks();
    }

    protected void unlockTypeLinks() {
        this.getLinkCache().unlockTypeLinks();
    }

    protected String getCollection(String repositoryId, String collection) {
        return this.getLinkCache().getCollection(repositoryId, collection);
    }

    protected String loadCollection(String repositoryId, String collection) {
        String link = this.getCollection(repositoryId, collection);
        if (link == null) {
            this.getRepositoriesInternal(repositoryId);
            link = this.getCollection(repositoryId, collection);
        }
        return link;
    }

    protected void addCollection(String repositoryId, String collection, String link) {
        this.getLinkCache().addCollection(repositoryId, collection, link);
    }

    protected String getRepositoryLink(String repositoryId, String rel) {
        return this.getLinkCache().getRepositoryLink(repositoryId, rel);
    }

    protected String loadRepositoryLink(String repositoryId, String rel) {
        String link = this.getRepositoryLink(repositoryId, rel);
        if (link == null) {
            this.getRepositoriesInternal(repositoryId);
            link = this.getRepositoryLink(repositoryId, rel);
        }
        return link;
    }

    protected void addRepositoryLink(String repositoryId, String rel, String link) {
        this.getLinkCache().addRepositoryLink(repositoryId, rel, link);
    }

    protected void addRepositoryLink(String repositoryId, AtomLink link) {
        this.addRepositoryLink(repositoryId, link.getRel(), link.getHref());
    }

    protected String getTemplateLink(String repositoryId, String type, Map<String, Object> parameters) {
        return this.getLinkCache().getTemplateLink(repositoryId, type, parameters);
    }

    protected String loadTemplateLink(String repositoryId, String type, Map<String, Object> parameters) {
        String link = this.getTemplateLink(repositoryId, type, parameters);
        if (link == null) {
            this.getRepositoriesInternal(repositoryId);
            link = this.getTemplateLink(repositoryId, type, parameters);
        }
        return link;
    }

    protected void addTemplate(String repositoryId, String type, String link) {
        this.getLinkCache().addTemplate(repositoryId, type, link);
    }

    protected CmisBaseException convertStatusCode(int code, String message, String errorContent, Throwable t) {
        String exception = this.extractException(errorContent);
        message = this.extractErrorMessage(message, errorContent);
        switch (code) {
            case 400: {
                if ("filterNotValid".equals(exception)) {
                    return new CmisFilterNotValidException(message, errorContent, t);
                }
                return new CmisInvalidArgumentException(message, errorContent, t);
            }
            case 401: {
                return new CmisUnauthorizedException(message, errorContent, t);
            }
            case 403: {
                if ("streamNotSupported".equals(exception)) {
                    return new CmisStreamNotSupportedException(message, errorContent, t);
                }
                return new CmisPermissionDeniedException(message, errorContent, t);
            }
            case 404: {
                return new CmisObjectNotFoundException(message, errorContent, t);
            }
            case 405: {
                return new CmisNotSupportedException(message, errorContent, t);
            }
            case 407: {
                return new CmisProxyAuthenticationException(message, errorContent, t);
            }
            case 409: {
                if ("contentAlreadyExists".equals(exception)) {
                    return new CmisContentAlreadyExistsException(message, errorContent, t);
                }
                if ("versioning".equals(exception)) {
                    return new CmisVersioningException(message, errorContent, t);
                }
                if ("updateConflict".equals(exception)) {
                    return new CmisUpdateConflictException(message, errorContent, t);
                }
                if ("nameConstraintViolation".equals(exception)) {
                    return new CmisNameConstraintViolationException(message, errorContent, t);
                }
                return new CmisConstraintException(message, errorContent, t);
            }
        }
        if ("storage".equals(exception)) {
            return new CmisStorageException(message, errorContent, t);
        }
        return new CmisRuntimeException(message, errorContent, t);
    }

    protected String extractException(String errorContent) {
        if (errorContent == null) {
            return null;
        }
        int begin = errorContent.indexOf("<!--exception-->");
        int end = errorContent.indexOf("<!--/exception-->");
        if (begin == -1 || end == -1 || begin > end) {
            return null;
        }
        return errorContent.substring(begin + "<!--exception-->".length(), end);
    }

    protected String extractErrorMessage(String message, String errorContent) {
        if (errorContent == null) {
            return message;
        }
        int begin = errorContent.indexOf("<!--message-->");
        int end = errorContent.indexOf("<!--/message-->");
        if (begin == -1 || end == -1 || begin > end) {
            return message;
        }
        return errorContent.substring(begin + "<!--message-->".length(), end);
    }

    protected boolean is(String name, AtomElement element) {
        return name.equals(element.getName().getLocalPart());
    }

    protected boolean isStr(String name, AtomElement element) {
        return this.is(name, element) && element.getObject() instanceof String;
    }

    protected boolean isInt(String name, AtomElement element) {
        return this.is(name, element) && element.getObject() instanceof BigInteger;
    }

    protected boolean isNextLink(AtomElement element) {
        return "next".equals(((AtomLink)element.getObject()).getRel());
    }

    protected CmisObjectType createIdObject(String objectId) {
        CmisObjectType object = new CmisObjectType();
        CmisPropertiesType properties = new CmisPropertiesType();
        object.setProperties(properties);
        CmisPropertyId idProperty = new CmisPropertyId();
        properties.getProperty().add(idProperty);
        idProperty.setPropertyDefinitionId("cmis:objectId");
        idProperty.getValue().add(objectId);
        return object;
    }

    protected <T extends AtomBase> T parse(InputStream stream, Class<T> clazz) {
        AtomPubParser parser = new AtomPubParser(stream);
        try {
            parser.parse();
        }
        catch (Exception e) {
            throw new CmisConnectionException("Parsing exception!", (Throwable)e);
        }
        AtomBase parseResult = parser.getResults();
        if (!clazz.isInstance(parseResult)) {
            throw new CmisConnectionException("Unexpected document! Received " + (parseResult == null ? "something unknown" : parseResult.getType()) + "!");
        }
        return (T)parseResult;
    }

    protected HttpUtils.Response read(UrlBuilder url) {
        HttpUtils.Response resp = HttpUtils.invokeGET(url, this.session);
        if (resp.getResponseCode() != 200) {
            throw this.convertStatusCode(resp.getResponseCode(), resp.getResponseMessage(), resp.getErrorContent(), null);
        }
        return resp;
    }

    protected HttpUtils.Response post(UrlBuilder url, String contentType, HttpUtils.Output writer) {
        HttpUtils.Response resp = HttpUtils.invokePOST(url, contentType, writer, this.session);
        if (resp.getResponseCode() != 201) {
            throw this.convertStatusCode(resp.getResponseCode(), resp.getResponseMessage(), resp.getErrorContent(), null);
        }
        return resp;
    }

    protected HttpUtils.Response put(UrlBuilder url, String contentType, HttpUtils.Output writer) {
        return this.put(url, contentType, null, writer);
    }

    protected HttpUtils.Response put(UrlBuilder url, String contentType, Map<String, String> headers, HttpUtils.Output writer) {
        HttpUtils.Response resp = HttpUtils.invokePUT(url, contentType, headers, writer, this.session);
        if (resp.getResponseCode() < 200 || resp.getResponseCode() > 299) {
            throw this.convertStatusCode(resp.getResponseCode(), resp.getResponseMessage(), resp.getErrorContent(), null);
        }
        return resp;
    }

    protected void delete(UrlBuilder url) {
        HttpUtils.Response resp = HttpUtils.invokeDELETE(url, this.session);
        if (resp.getResponseCode() != 204) {
            throw this.convertStatusCode(resp.getResponseCode(), resp.getResponseMessage(), resp.getErrorContent(), null);
        }
    }

    protected boolean isAclMergeRequired(Acl addAces, Acl removeAces) {
        return addAces != null && addAces.getAces() != null && !addAces.getAces().isEmpty() || removeAces != null && removeAces.getAces() != null && !removeAces.getAces().isEmpty();
    }

    protected Acl mergeAcls(Acl originalAces, Acl addAces, Acl removeAces) {
        Map<String, Set<String>> originals = AbstractAtomPubService.convertAclToMap(originalAces);
        Map<String, Set<String>> adds = AbstractAtomPubService.convertAclToMap(addAces);
        Map<String, Set<String>> removes = AbstractAtomPubService.convertAclToMap(removeAces);
        ArrayList<AccessControlEntryImpl> newAces = new ArrayList<AccessControlEntryImpl>();
        for (Map.Entry<String, Set<String>> ace : originals.entrySet()) {
            Set<String> removePermissions;
            Set<String> addPermissions = adds.get(ace.getKey());
            if (addPermissions != null) {
                ace.getValue().addAll(addPermissions);
            }
            if ((removePermissions = removes.get(ace.getKey())) != null) {
                ace.getValue().removeAll(removePermissions);
            }
            if (ace.getValue().isEmpty()) continue;
            newAces.add(new AccessControlEntryImpl((Principal)new AccessControlPrincipalDataImpl(ace.getKey()), new ArrayList(ace.getValue())));
        }
        for (Map.Entry<String, Set<String>> ace : adds.entrySet()) {
            if (originals.containsKey(ace.getKey()) || ace.getValue().isEmpty()) continue;
            newAces.add(new AccessControlEntryImpl((Principal)new AccessControlPrincipalDataImpl(ace.getKey()), new ArrayList(ace.getValue())));
        }
        return new AccessControlListImpl(newAces);
    }

    private static Map<String, Set<String>> convertAclToMap(Acl acl) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        if (acl == null || acl.getAces() == null) {
            return result;
        }
        for (Ace ace : acl.getAces()) {
            if (!ace.isDirect() || ace.getPrincipal() == null || ace.getPrincipal().getId() == null) continue;
            HashSet permissions = (HashSet)result.get(ace.getPrincipal().getId());
            if (permissions == null) {
                permissions = new HashSet();
                result.put(ace.getPrincipal().getId(), permissions);
            }
            if (ace.getPermissions() == null) continue;
            permissions.addAll(ace.getPermissions());
        }
        return result;
    }

    protected List<RepositoryInfo> getRepositoriesInternal(String repositoryId) {
        ArrayList<RepositoryInfo> repInfos = new ArrayList<RepositoryInfo>();
        UrlBuilder url = new UrlBuilder(this.getServiceDocURL());
        url.addParameter("repositoryId", (Object)repositoryId);
        HttpUtils.Response resp = this.read(url);
        ServiceDoc serviceDoc = this.parse(resp.getStream(), ServiceDoc.class);
        for (RepositoryWorkspace ws : serviceDoc.getWorkspaces()) {
            if (ws.getId() == null) continue;
            for (AtomElement element : ws.getElements()) {
                if (this.is(NAME_COLLECTION, element)) {
                    Map colMap = (Map)element.getObject();
                    this.addCollection(ws.getId(), (String)colMap.get("collectionType"), (String)colMap.get("href"));
                    continue;
                }
                if (element.getObject() instanceof AtomLink) {
                    this.addRepositoryLink(ws.getId(), (AtomLink)element.getObject());
                    continue;
                }
                if (this.is(NAME_URI_TEMPLATE, element)) {
                    Map tempMap = (Map)element.getObject();
                    this.addTemplate(ws.getId(), (String)tempMap.get("type"), (String)tempMap.get("template"));
                    continue;
                }
                if (!(element.getObject() instanceof CmisRepositoryInfoType)) continue;
                repInfos.add(Converter.convert((CmisRepositoryInfoType)((CmisRepositoryInfoType)element.getObject())));
            }
        }
        return repInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectData getObjectInternal(String repositoryId, IdentifierType idOrPath, String objectIdOrPath, ReturnVersion returnVersion, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        HttpUtils.Response resp;
        AtomEntry entry;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", objectIdOrPath);
        parameters.put("path", objectIdOrPath);
        parameters.put("returnVersion", returnVersion);
        parameters.put("filter", filter);
        parameters.put("includeAllowableActions", includeAllowableActions);
        parameters.put("includeACL", includeAcl);
        parameters.put("includePolicyIds", includePolicyIds);
        parameters.put("includeRelationships", includeRelationships);
        parameters.put("renditionFilter", renditionFilter);
        String link = this.loadTemplateLink(repositoryId, idOrPath == IdentifierType.ID ? "objectbyid" : "objectbypath", parameters);
        if (link == null) {
            throw new CmisObjectNotFoundException("Unknown repository!");
        }
        UrlBuilder url = new UrlBuilder(link);
        if (returnVersion != null && returnVersion != ReturnVersion.THIS) {
            url.addParameter("returnVersion", (Object)returnVersion);
        }
        if ((entry = this.parse((resp = this.read(url)).getStream(), AtomEntry.class)).getId() == null) {
            throw new CmisConnectionException("Received Atom entry is not a CMIS entry!");
        }
        this.lockLinks();
        ObjectData result = null;
        try {
            this.removeLinks(repositoryId, entry.getId());
            for (AtomElement element : entry.getElements()) {
                if (element.getObject() instanceof AtomLink) {
                    this.addLink(repositoryId, entry.getId(), (AtomLink)element.getObject());
                    continue;
                }
                if (!(element.getObject() instanceof CmisObjectType)) continue;
                result = Converter.convert((CmisObjectType)((CmisObjectType)element.getObject()));
            }
        }
        finally {
            this.unlockLinks();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TypeDefinition getTypeDefinitionInternal(String repositoryId, String typeId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", typeId);
        String link = this.loadTemplateLink(repositoryId, "typebyid", parameters);
        if (link == null) {
            throw new CmisObjectNotFoundException("Unknown repository!");
        }
        HttpUtils.Response resp = this.read(new UrlBuilder(link));
        AtomEntry entry = this.parse(resp.getStream(), AtomEntry.class);
        if (entry.getId() == null) {
            throw new CmisConnectionException("Received Atom entry is not a CMIS entry!");
        }
        this.lockTypeLinks();
        TypeDefinition result = null;
        try {
            this.removeTypeLinks(repositoryId, entry.getId());
            for (AtomElement element : entry.getElements()) {
                if (element.getObject() instanceof AtomLink) {
                    this.addTypeLink(repositoryId, entry.getId(), (AtomLink)element.getObject());
                    continue;
                }
                if (!(element.getObject() instanceof CmisTypeDefinitionType)) continue;
                result = Converter.convert((CmisTypeDefinitionType)((CmisTypeDefinitionType)element.getObject()));
            }
        }
        finally {
            this.unlockTypeLinks();
        }
        return result;
    }

    protected AtomAcl updateAcl(String repositoryId, String objectId, Acl acl, AclPropagation aclPropagation) {
        String link = this.loadLink(repositoryId, objectId, "http://docs.oasis-open.org/ns/cmis/link/200908/acl", "application/cmisacl+xml");
        if (link == null) {
            this.throwLinkException(repositoryId, objectId, "http://docs.oasis-open.org/ns/cmis/link/200908/acl", "application/cmisacl+xml");
        }
        UrlBuilder aclUrl = new UrlBuilder(link);
        aclUrl.addParameter("ACLPropagation", (Object)aclPropagation);
        final CmisAccessControlListType aclJaxb = Converter.convert((Acl)acl);
        HttpUtils.Response resp = this.put(aclUrl, "application/cmisacl+xml", new HttpUtils.Output(){

            public void write(OutputStream out) throws Exception {
                JaxBHelper.marshal((JAXBElement)JaxBHelper.CMIS_OBJECT_FACTORY.createAcl(aclJaxb), (OutputStream)out, (boolean)false);
            }
        });
        return this.parse(resp.getStream(), AtomAcl.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum IdentifierType {
        ID,
        PATH;

    }
}

