/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFastFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

class CassandraClient
implements Closeable {
    TTransport transport;
    Cassandra.Client client;

    CassandraClient(String hostName, int port, boolean framed) throws TTransportException {
        TSocket socket = new TSocket(hostName, port);
        this.transport = framed ? socket : new TFastFramedTransport((TTransport)socket);
        this.transport.open();
        this.client = new Cassandra.Client((TProtocol)new TBinaryProtocol(this.transport));
        try {
            this.client.set_cql_version("3.0.0");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    CqlResult execute_cql_query(ByteBuffer cqlQuery, Compression compression) throws Exception {
        return this.client.execute_cql3_query(cqlQuery, compression, ConsistencyLevel.ONE);
    }

    String describe_partitioner() throws TException, InvalidRequestException {
        return this.client.describe_partitioner();
    }

    List<TokenRange> describe_ring(String keyspace) throws InvalidRequestException, TException {
        return this.client.describe_ring(keyspace);
    }

    Map<String, String> describe_token_map() throws InvalidRequestException, TException {
        return this.client.describe_token_map();
    }

    @Override
    public void close() {
        this.transport.close();
    }
}

