/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.utils.Pair;

public class MapType<K, V>
extends CollectionType<Map<K, V>> {
    private static final Map<Pair<AbstractType<?>, AbstractType<?>>, MapType> instances = new HashMap();
    public final AbstractType<K> keys;
    public final AbstractType<V> values;

    public static MapType<?, ?> getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        List<AbstractType<?>> l = parser.getTypeParameters();
        if (l.size() != 2) {
            throw new ConfigurationException("MapType takes exactly 2 type parameters");
        }
        return MapType.getInstance(l.get(0), l.get(1));
    }

    public static synchronized <K, V> MapType<K, V> getInstance(AbstractType<K> keys, AbstractType<V> values) {
        Pair<AbstractType<K>, AbstractType<V>> p = Pair.create(keys, values);
        MapType<K, V> t = instances.get(p);
        if (t == null) {
            t = new MapType<K, V>(keys, values);
            instances.put(p, t);
        }
        return t;
    }

    private MapType(AbstractType<K> keys, AbstractType<V> values) {
        super(CollectionType.Kind.MAP);
        this.keys = keys;
        this.values = values;
    }

    @Override
    public AbstractType<K> nameComparator() {
        return this.keys;
    }

    @Override
    public AbstractType<V> valueComparator() {
        return this.values;
    }

    @Override
    public Map<K, V> compose(ByteBuffer bytes) {
        try {
            ByteBuffer input = bytes.duplicate();
            int n = MapType.getUnsignedShort(input);
            LinkedHashMap<K, V> m = new LinkedHashMap<K, V>(n);
            for (int i = 0; i < n; ++i) {
                int sk = MapType.getUnsignedShort(input);
                byte[] datak = new byte[sk];
                input.get(datak);
                ByteBuffer kbb = ByteBuffer.wrap(datak);
                this.keys.validate(kbb);
                int sv = MapType.getUnsignedShort(input);
                byte[] datav = new byte[sv];
                input.get(datav);
                ByteBuffer vbb = ByteBuffer.wrap(datav);
                this.values.validate(vbb);
                m.put(this.keys.compose(kbb), this.values.compose(vbb));
            }
            return m;
        }
        catch (BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a map");
        }
    }

    @Override
    public ByteBuffer decompose(Map<K, V> value) {
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(2 * value.size());
        int size = 0;
        for (Map.Entry<K, V> entry : value.entrySet()) {
            ByteBuffer bbk = this.keys.decompose(entry.getKey());
            ByteBuffer bbv = this.values.decompose(entry.getValue());
            bbs.add(bbk);
            bbs.add(bbv);
            size += 4 + bbk.remaining() + bbv.remaining();
        }
        return MapType.pack(bbs, value.size(), size);
    }

    @Override
    protected void appendToStringBuilder(StringBuilder sb) {
        sb.append(this.getClass().getName()).append(TypeParser.stringifyTypeParameters(Arrays.asList(this.keys, this.values)));
    }

    @Override
    public ByteBuffer serialize(List<Pair<ByteBuffer, IColumn>> columns) {
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(2 * columns.size());
        int size = 0;
        for (Pair<ByteBuffer, IColumn> p : columns) {
            bbs.add((ByteBuffer)p.left);
            bbs.add(((IColumn)p.right).value());
            size += 4 + ((ByteBuffer)p.left).remaining() + ((IColumn)p.right).value().remaining();
        }
        return MapType.pack(bbs, columns.size(), size);
    }
}

