/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;

public class SimpleBindings
implements Bindings {
    private final Map map;

    public SimpleBindings() {
        this.map = new HashMap();
    }

    public SimpleBindings(Map map) {
        if (map == null) {
            throw new NullPointerException("parameter must not be null");
        }
        this.map = map;
    }

    private void validateKey(Object key) {
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        if (!(key instanceof String)) {
            throw new ClassCastException("key must be a String");
        }
        if (((String)key).length() == 0) {
            throw new IllegalArgumentException("key must not be the empty string");
        }
    }

    public Object put(Object key, Object value) {
        this.validateKey(key);
        return this.put((String)key, value);
    }

    public Object put(String key, Object value) {
        this.validateKey(key);
        return this.map.put(key, value);
    }

    public void putAll(Map toMerge) {
        Set keySet = toMerge.keySet();
        Iterator keys = keySet.iterator();
        while (keys.hasNext()) {
            this.validateKey(keys.next());
        }
        this.map.putAll(toMerge);
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        this.validateKey(key);
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Collection values() {
        return this.map.values();
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public Object get(Object key) {
        this.validateKey(key);
        return this.map.get(key);
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Object remove(Object key) {
        this.validateKey(key);
        return this.map.remove(key);
    }
}

