/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms.pool;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.XAConnectionFactory;
import org.apache.activemq.jms.pool.ConnectionKey;
import org.apache.activemq.jms.pool.ConnectionPool;
import org.apache.activemq.jms.pool.PooledConnection;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledConnectionFactory
implements ConnectionFactory {
    private static final transient Logger LOG = LoggerFactory.getLogger(PooledConnectionFactory.class);
    protected final AtomicBoolean stopped = new AtomicBoolean(false);
    private GenericKeyedObjectPool<ConnectionKey, ConnectionPool> connectionsPool;
    private ConnectionFactory connectionFactory;
    private int maximumActiveSessionPerConnection = 500;
    private int idleTimeout = 30000;
    private boolean blockIfSessionPoolIsFull = true;
    private long expiryTimeout = 0L;
    private boolean createConnectionOnStartup = true;
    private boolean useAnonymousProducers = true;

    public void initConnectionsPool() {
        if (this.connectionsPool == null) {
            this.connectionsPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new KeyedPoolableObjectFactory<ConnectionKey, ConnectionPool>(){

                public void activateObject(ConnectionKey key, ConnectionPool connection) throws Exception {
                }

                public void destroyObject(ConnectionKey key, ConnectionPool connection) throws Exception {
                    try {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Destroying connection: {}", (Object)connection);
                        }
                        connection.close();
                    }
                    catch (Exception e) {
                        LOG.warn("Close connection failed for connection: " + connection + ". This exception will be ignored.", (Throwable)e);
                    }
                }

                public ConnectionPool makeObject(ConnectionKey key) throws Exception {
                    Connection delegate = PooledConnectionFactory.this.createConnection(key);
                    ConnectionPool connection = PooledConnectionFactory.this.createConnectionPool(delegate);
                    connection.setIdleTimeout(PooledConnectionFactory.this.getIdleTimeout());
                    connection.setExpiryTimeout(PooledConnectionFactory.this.getExpiryTimeout());
                    connection.setMaximumActiveSessionPerConnection(PooledConnectionFactory.this.getMaximumActiveSessionPerConnection());
                    connection.setBlockIfSessionPoolIsFull(PooledConnectionFactory.this.isBlockIfSessionPoolIsFull());
                    connection.setUseAnonymousProducers(PooledConnectionFactory.this.isUseAnonymousProducers());
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Created new connection: {}", (Object)connection);
                    }
                    return connection;
                }

                public void passivateObject(ConnectionKey key, ConnectionPool connection) throws Exception {
                }

                public boolean validateObject(ConnectionKey key, ConnectionPool connection) {
                    if (connection != null && connection.expiredCheck()) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Connection has expired: {} and will be destroyed", (Object)connection);
                        }
                        return false;
                    }
                    return true;
                }
            });
            this.connectionsPool.setMaxIdle(1);
            this.connectionsPool.setTestOnBorrow(true);
            this.connectionsPool.setTestWhileIdle(true);
        }
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(final ConnectionFactory toUse) {
        this.connectionFactory = toUse instanceof XAConnectionFactory ? new ConnectionFactory(){

            public Connection createConnection() throws JMSException {
                return ((XAConnectionFactory)toUse).createXAConnection();
            }

            public Connection createConnection(String userName, String password) throws JMSException {
                return ((XAConnectionFactory)toUse).createXAConnection(userName, password);
            }
        } : toUse;
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Connection createConnection(String userName, String password) throws JMSException {
        if (this.stopped.get()) {
            LOG.debug("PooledConnectionFactory is stopped, skip create new connection.");
            return null;
        }
        ConnectionPool connection = null;
        ConnectionKey key = new ConnectionKey(userName, password);
        if (this.getConnectionsPool().getNumIdle((Object)key) < this.getMaxConnections()) {
            try {
                this.connectionsPool.setLifo(true);
                this.connectionsPool.addObject((Object)key);
            }
            catch (Exception e) {
                throw this.createJmsException("Error while attempting to add new Connection to the pool", e);
            }
        } else {
            this.connectionsPool.setLifo(false);
        }
        try {
            while (connection == null) {
                ConnectionPool e = connection = (ConnectionPool)this.connectionsPool.borrowObject((Object)key);
                synchronized (e) {
                    if (connection.getConnection() != null) {
                        connection.incrementReferenceCount();
                        break;
                    }
                    this.connectionsPool.returnObject((Object)key, (Object)connection);
                    connection = null;
                }
            }
        }
        catch (Exception e) {
            throw this.createJmsException("Error while attempting to retrieve a connection from the pool", e);
        }
        try {
            this.connectionsPool.returnObject((Object)key, (Object)connection);
            return this.newPooledConnection(connection);
        }
        catch (Exception e) {
            throw this.createJmsException("Error when returning connection to the pool", e);
        }
    }

    protected Connection newPooledConnection(ConnectionPool connection) {
        return new PooledConnection(connection);
    }

    private JMSException createJmsException(String msg, Exception cause) {
        JMSException exception = new JMSException(msg);
        exception.setLinkedException(cause);
        exception.initCause((Throwable)cause);
        return exception;
    }

    protected Connection createConnection(ConnectionKey key) throws JMSException {
        if (key.getUserName() == null && key.getPassword() == null) {
            return this.connectionFactory.createConnection();
        }
        return this.connectionFactory.createConnection(key.getUserName(), key.getPassword());
    }

    public void start() {
        LOG.debug("Staring the PooledConnectionFactory: create on start = {}", (Object)this.isCreateConnectionOnStartup());
        this.stopped.set(false);
        if (this.isCreateConnectionOnStartup()) {
            try {
                this.createConnection();
            }
            catch (JMSException e) {
                LOG.warn("Create pooled connection during start failed. This exception will be ignored.", (Throwable)e);
            }
        }
    }

    public void stop() {
        if (this.stopped.compareAndSet(false, true)) {
            LOG.debug("Stopping the PooledConnectionFactory, number of connections in cache: {}", (Object)(this.connectionsPool != null ? this.connectionsPool.getNumActive() : 0));
            try {
                if (this.connectionsPool != null) {
                    this.connectionsPool.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void clear() {
        if (this.stopped.get()) {
            return;
        }
        this.getConnectionsPool().clear();
    }

    public int getMaximumActiveSessionPerConnection() {
        return this.maximumActiveSessionPerConnection;
    }

    public void setMaximumActiveSessionPerConnection(int maximumActiveSessionPerConnection) {
        this.maximumActiveSessionPerConnection = maximumActiveSessionPerConnection;
    }

    public void setBlockIfSessionPoolIsFull(boolean block) {
        this.blockIfSessionPoolIsFull = block;
    }

    public boolean isBlockIfSessionPoolIsFull() {
        return this.blockIfSessionPoolIsFull;
    }

    public int getMaxConnections() {
        return this.getConnectionsPool().getMaxIdle();
    }

    public void setMaxConnections(int maxConnections) {
        this.getConnectionsPool().setMaxIdle(maxConnections);
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setExpiryTimeout(long expiryTimeout) {
        this.expiryTimeout = expiryTimeout;
    }

    public long getExpiryTimeout() {
        return this.expiryTimeout;
    }

    public boolean isCreateConnectionOnStartup() {
        return this.createConnectionOnStartup;
    }

    public void setCreateConnectionOnStartup(boolean createConnectionOnStartup) {
        this.createConnectionOnStartup = createConnectionOnStartup;
    }

    public boolean isUseAnonymousProducers() {
        return this.useAnonymousProducers;
    }

    public void setUseAnonymousProducers(boolean value) {
        this.useAnonymousProducers = value;
    }

    protected GenericKeyedObjectPool<ConnectionKey, ConnectionPool> getConnectionsPool() {
        this.initConnectionsPool();
        return this.connectionsPool;
    }

    public void setTimeBetweenExpirationCheckMillis(long timeBetweenExpirationCheckMillis) {
        this.getConnectionsPool().setTimeBetweenEvictionRunsMillis(timeBetweenExpirationCheckMillis);
    }

    public long getTimeBetweenExpirationCheckMillis() {
        return this.getConnectionsPool().getTimeBetweenEvictionRunsMillis();
    }

    public int getNumConnections() {
        return this.getConnectionsPool().getNumIdle();
    }

    protected ConnectionPool createConnectionPool(Connection connection) {
        return new ConnectionPool(connection);
    }
}

