/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.repositories.emf;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.andromda.core.common.ResourceFinder;
import org.andromda.core.engine.ModelProcessor;
import org.andromda.core.metafacade.ModelAccessFacade;
import org.andromda.core.repository.RepositoryFacade;
import org.andromda.core.repository.RepositoryFacadeException;
import org.andromda.repositories.emf.EMFRepositoryFacadeUtils;
import org.andromda.repositories.emf.EMFURIConverter;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;

public abstract class EMFRepositoryFacade
implements RepositoryFacade {
    private static final Logger logger = Logger.getLogger(EMFRepositoryFacade.class);
    protected ResourceSet resourceSet;
    protected ModelAccessFacade modelFacade;
    protected List<Resource> model;
    private Map<String, Boolean> loadOptions = new HashMap<String, Boolean>();
    private static final String MODULES_PATH = "META-INF/emf/modules";

    protected Map<String, Boolean> getLoadOptions() {
        return this.loadOptions;
    }

    public void readModel(String uri) {
        try {
            EList warnings;
            Resource modelResource;
            if (this.model == null) {
                this.model = new ArrayList<Resource>();
            }
            if ((modelResource = this.resourceSet.createResource(EMFRepositoryFacadeUtils.createUri(uri))) == null) {
                throw new RepositoryFacadeException('\'' + uri + "' is an invalid model");
            }
            modelResource.load(this.getLoadOptions());
            EList errors = modelResource.getErrors();
            if (errors != null && !errors.isEmpty()) {
                logger.info((Object)errors);
            }
            if ((warnings = modelResource.getWarnings()) != null && !warnings.isEmpty()) {
                logger.info((Object)warnings);
            }
            if (ModelProcessor.getModelValidation()) {
                try {
                    TreeIterator i = modelResource.getAllContents();
                    while (i.hasNext()) {
                        EObject eObject = (EObject)i.next();
                        Iterator crossRefIterator = eObject.eCrossReferences().iterator();
                        while (crossRefIterator.hasNext()) {
                            try {
                                crossRefIterator.next();
                            }
                            catch (Exception ex) {
                                logger.error((Object)("EMFRepositoryFacade.readModel.resolveAll on " + eObject + ": " + ex));
                            }
                        }
                    }
                }
                catch (RuntimeException e) {
                    logger.error((Object)("EMFRepositoryFacade.readModel.resolveAll :" + e));
                }
            }
            this.model.add(modelResource);
        }
        catch (Exception exception) {
            throw new RepositoryFacadeException((Throwable)exception);
        }
    }

    public void open() {
        this.resourceSet = this.createNewResourceSet();
    }

    public abstract ResourceSet createNewResourceSet();

    public abstract void close();

    public void readModel(String[] modelUris, String[] moduleSearchPaths) {
        int ctr;
        URL[] classpathSearchPaths;
        if (modelUris == null || modelUris.length == 0) {
            throw new RepositoryFacadeException("No model specified.");
        }
        ArrayList<String> moduleSearchPathList = new ArrayList<String>();
        if (moduleSearchPaths != null) {
            moduleSearchPathList.addAll(Arrays.asList(moduleSearchPaths));
        }
        if ((classpathSearchPaths = ResourceFinder.findResources((String)MODULES_PATH)) != null) {
            classpathSearchPaths = ResourceFinder.findResources((String)"profiles");
        }
        if (classpathSearchPaths != null) {
            int numberOfClasspathSearchPaths = classpathSearchPaths.length;
            for (ctr = 0; ctr < numberOfClasspathSearchPaths; ++ctr) {
                URL classpathSearchPath = classpathSearchPaths[ctr];
                if (classpathSearchPath == null) continue;
                moduleSearchPathList.add(classpathSearchPath.toString());
            }
        }
        logger.debug((Object)("ModuleSearchPaths: " + moduleSearchPathList));
        this.resourceSet.setURIConverter((URIConverter)new EMFURIConverter(moduleSearchPathList, this.resourceSet.getURIConverter().getURIMap()));
        if (modelUris.length > 0) {
            int numberOfModelUris = modelUris.length;
            for (ctr = 0; ctr < numberOfModelUris; ++ctr) {
                this.readModel(modelUris[ctr]);
            }
        }
    }

    public void readModel(InputStream[] stream, String[] modelUri, String[] moduleSearchPaths) {
        this.readModel(modelUri, moduleSearchPaths);
    }

    public void writeModel(Object modelIn, String location, String version, String encoding) {
        this.writeModel(modelIn, location, "");
    }

    public void writeModel(Object modelIn, String location, String version) {
        EModelElement element = (EModelElement)modelIn;
        Resource resource = element.eResource();
        URI uri = URI.createURI((String)location);
        resource.setURI(uri);
        try {
            resource.save(null);
        }
        catch (IOException exception) {
            throw new RepositoryFacadeException("Could not save model", (Throwable)exception);
        }
    }

    public void clear() {
        this.model = null;
        this.resourceSet = this.createNewResourceSet();
    }
}

