/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.maven.plugin.andromdapp.hibernate;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.andromda.core.common.Constants;
import org.andromda.core.common.ResourceWriter;
import org.andromda.maven.plugin.andromdapp.hibernate.HibernateSchemaManagement;
import org.apache.commons.lang.StringUtils;

public class HibernateUpdateSchema
extends HibernateSchemaManagement {
    private static final String HIBERNATE_PROPERTIES_TEMP_DIRECTORY = Constants.TEMPORARY_DIRECTORY + "andromdapp/hibernate-schema-update";
    private static final Random random = new Random();
    private ClassLoader jdbcDriverJarLoader = null;

    @Override
    protected void addArguments(Map options, List<String> arguments) throws Exception {
        String driverClass = this.getRequiredProperty(options, "jdbcDriver");
        String connectionUrl = this.getRequiredProperty(options, "jdbcConnectionUrl");
        String username = this.getRequiredProperty(options, "jdbcUsername");
        String password = this.getProperty(options, "jdbcPassword");
        StringBuilder contents = new StringBuilder();
        contents.append("hibernate.connection.driver_class=").append(driverClass).append('\n');
        contents.append("hibernate.connection.url=").append(connectionUrl).append('\n');
        contents.append("hibernate.connection.username=").append(username).append('\n');
        if (StringUtils.isNotBlank((String)password)) {
            contents.append("hibernate.connection.password=").append(password).append('\n');
        }
        File temporaryProperitesFile = new File(HIBERNATE_PROPERTIES_TEMP_DIRECTORY, String.valueOf(random.nextDouble()));
        temporaryProperitesFile.deleteOnExit();
        ResourceWriter.instance().writeStringToFile(contents.toString(), temporaryProperitesFile.toString());
        arguments.add("--properties=" + temporaryProperitesFile);
    }

    protected ClassLoader getJdbcDriverJarLoader(Map options) throws MalformedURLException {
        String jdbcDriverJar = this.getRequiredProperty(options, "jdbcDriverJar");
        if (this.jdbcDriverJarLoader == null) {
            this.jdbcDriverJarLoader = new URLClassLoader(new URL[]{new File(jdbcDriverJar).toURI().toURL()});
        }
        return this.jdbcDriverJarLoader;
    }

    @Override
    protected String getExecutionOuputPath(Map options) {
        return null;
    }

    @Override
    protected String getExecutionClassName() {
        return "SchemaUpdate";
    }
}

