/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.maven.plugin.andromdapp;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.ClassUtils;
import org.andromda.core.common.ResourceUtils;
import org.andromda.maven.plugin.andromdapp.JdbcDriverWrapper;
import org.andromda.maven.plugin.andromdapp.SchemaManagement;
import org.andromda.maven.plugin.andromdapp.hibernate.HibernateCreateSchema;
import org.andromda.maven.plugin.andromdapp.hibernate.HibernateDropSchema;
import org.andromda.maven.plugin.andromdapp.hibernate.HibernateUpdateSchema;
import org.andromda.maven.plugin.andromdapp.hibernate.HibernateValidateSchema;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class SchemaMojo
extends AbstractMojo {
    private String tasks;
    private String taskType;
    private MavenProject project;
    private String[] propertyFiles;
    private Properties properties = new Properties();
    private ArtifactFactory factory;
    private boolean executeScripts = true;
    private List<Artifact> pluginArtifacts;
    private ArtifactResolver artifactResolver;
    private ArtifactRepository localRepository;
    private String jdbcDriver;
    private String jdbcConnectionUrl;
    private String jdbcUsername;
    private String jdbcPassword = "";
    private String jdbcDriverJar;
    private List<String> scripts;
    private static final String STATEMENT_END = ";";
    private int successes;
    private int failures;
    private static final HashMap<String, Map<String, Class>> tasksCache = new LinkedHashMap<String, Map<String, Class>>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        Connection connection = null;
        try {
            AndroMDALogger.initialize();
            this.initializeClassLoaderWithJdbcDriver();
            List<String> tasks = this.getTasks();
            if (tasks != null && !tasks.isEmpty()) {
                Map<String, Class> tasksMap = tasksCache.get(this.taskType);
                if (tasksMap == null) {
                    throw new MojoExecutionException('\'' + this.taskType + "' is not a valid task type, valid task types are: " + tasksMap.keySet());
                }
                this.properties.putAll((Map<?, ?>)this.project.getProperties());
                for (String task : this.getTasks()) {
                    Field[] fields;
                    task = ObjectUtils.toString((Object)task.trim());
                    if (this.propertyFiles != null) {
                        int numberOfPropertyFiles = this.propertyFiles.length;
                        for (int ctr2 = 0; ctr2 < numberOfPropertyFiles; ++ctr2) {
                            URL propertyFileUri = ResourceUtils.toURL((String)this.propertyFiles[ctr2]);
                            if (propertyFileUri == null) continue;
                            InputStream stream = propertyFileUri.openStream();
                            this.properties.load(stream);
                            stream.close();
                        }
                    }
                    if ((fields = ((Object)((Object)this)).getClass().getDeclaredFields()) != null) {
                        int numberOfFields = fields.length;
                        for (int ctr = 0; ctr < numberOfFields; ++ctr) {
                            Field field = fields[ctr];
                            Object value = field.get((Object)this);
                            if (value == null) continue;
                            this.properties.put(field.getName(), value);
                        }
                    }
                    LinkedHashSet<String> classpathElements = new LinkedHashSet<String>(this.project.getRuntimeClasspathElements());
                    classpathElements.addAll(this.getProvidedClasspathElements());
                    this.initializeClasspathFromClassPathElements(classpathElements);
                    Class type = tasksMap.get(task);
                    if (type == null) {
                        throw new MojoExecutionException('\'' + task + "' is not a valid task, valid types are: " + tasksMap.keySet());
                    }
                    SchemaManagement schemaManagement = (SchemaManagement)ClassUtils.newInstance((Class)type);
                    connection = this.executeScripts ? this.getConnection() : null;
                    this.executeSql(connection, schemaManagement.execute(connection, this.properties));
                }
            }
            this.executeScripts(connection);
        }
        catch (Throwable throwable) {
            throw new MojoExecutionException("An error occured while attempting to create the schema", throwable);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    private List<String> getTasks() {
        return this.tasks != null ? Arrays.asList(this.tasks.split(",")) : null;
    }

    private void executeScripts(Connection connection) throws MojoExecutionException {
        List<String> tasks = this.getTasks();
        if (this.scripts != null && !this.scripts.isEmpty()) {
            for (String location : this.scripts) {
                try {
                    this.executeSql(connection, location);
                }
                catch (Exception exception) {
                    throw new MojoExecutionException("Execution failed on script: " + location, exception);
                }
            }
        } else if (tasks == null || tasks.isEmpty()) {
            this.getLog().info((CharSequence)"No scripts found to execute");
        }
    }

    protected void initializeClasspathFromClassPathElements(Set<String> classpathFiles) throws MalformedURLException {
        ArrayList<String> files;
        if (this.pluginArtifacts != null) {
            for (Artifact artifact : this.pluginArtifacts) {
                File artifactFile = artifact.getFile();
                if (artifactFile == null) continue;
                classpathFiles.add(artifactFile.toString());
            }
        }
        if (!(files = new ArrayList<String>(classpathFiles)).isEmpty()) {
            URL[] classpathUrls = new URL[classpathFiles.size()];
            for (int ctr = 0; ctr < classpathFiles.size(); ++ctr) {
                File file = new File((String)files.get(ctr));
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("adding to classpath '" + file + '\''));
                }
                classpathUrls[ctr] = file.toURI().toURL();
            }
            URLClassLoader loader = new URLClassLoader(classpathUrls, Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    protected void initializeClassLoaderWithJdbcDriver() throws MalformedURLException {
        Thread.currentThread().setContextClassLoader(new URLClassLoader(new URL[]{new File(this.jdbcDriverJar).toURI().toURL()}, Thread.currentThread().getContextClassLoader()));
    }

    protected List<String> getProvidedClasspathElements() throws ArtifactResolutionException, ArtifactNotFoundException {
        ArrayList<String> classpathElements = new ArrayList<String>();
        List dependencies = this.project.getDependencies();
        if (dependencies != null && !dependencies.isEmpty()) {
            for (Dependency dependency : dependencies) {
                String file;
                if (!"provided".equals(dependency.getScope()) || (file = this.getDependencyFile(dependency)) == null) continue;
                classpathElements.add(file);
            }
        }
        return classpathElements;
    }

    private String getDependencyFile(Dependency dependency) throws ArtifactResolutionException, ArtifactNotFoundException {
        String file = null;
        if (dependency != null) {
            Artifact artifact = this.factory.createArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), null, dependency.getType());
            this.artifactResolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
            file = artifact.getFile() != null ? artifact.getFile().toString() : null;
        }
        return file;
    }

    protected Connection getConnection() throws Exception {
        Driver driver = (Driver)ClassUtils.loadClass((String)this.jdbcDriver).newInstance();
        DriverManager.registerDriver(new JdbcDriverWrapper(driver));
        return DriverManager.getConnection(this.jdbcConnectionUrl, this.jdbcUsername, this.jdbcPassword);
    }

    public void executeSql(Connection connection, String sqlPath) throws Exception {
        if (StringUtils.isNotBlank((String)sqlPath)) {
            URL sqlUrl = ResourceUtils.toURL((String)sqlPath);
            if (sqlUrl != null) {
                this.successes = 0;
                this.failures = 0;
                Statement statement = null;
                if (connection != null) {
                    statement = connection.createStatement();
                }
                InputStream stream = sqlUrl.openStream();
                BufferedReader resourceInput = new BufferedReader(new InputStreamReader(stream));
                StringBuilder sql = new StringBuilder();
                String line = resourceInput.readLine();
                while (line != null) {
                    if (!line.startsWith("//") && !line.startsWith("--")) {
                        sql.append(line);
                        if (line.endsWith(STATEMENT_END)) {
                            if (statement != null) {
                                this.executeSql(statement, sql.toString().replaceAll(STATEMENT_END, ""));
                            }
                            sql = new StringBuilder();
                        }
                        sql.append('\n');
                    }
                    line = resourceInput.readLine();
                }
                resourceInput.close();
                if (statement != null) {
                    statement.close();
                }
            }
            this.getLog().info((CharSequence)(" Executed script: " + sqlPath));
            String count = String.valueOf(this.successes + this.failures);
            this.getLog().info((CharSequence)(' ' + count + "  SQL statements executed"));
            this.getLog().info((CharSequence)(" Failures: " + this.failures));
            this.getLog().info((CharSequence)(" Successes: " + this.successes));
        }
    }

    private void executeSql(Statement statement, String sql) {
        this.getLog().info((CharSequence)sql.trim());
        try {
            statement.execute(sql);
            ++this.successes;
        }
        catch (SQLException exception) {
            ++this.failures;
            this.getLog().warn((CharSequence)exception.toString());
        }
    }

    static {
        LinkedHashMap<String, Class> hibernateTasks = new LinkedHashMap<String, Class>();
        tasksCache.put("hibernate", hibernateTasks);
        hibernateTasks.put("create", HibernateCreateSchema.class);
        hibernateTasks.put("drop", HibernateDropSchema.class);
        hibernateTasks.put("update", HibernateUpdateSchema.class);
        hibernateTasks.put("validate", HibernateValidateSchema.class);
    }
}

