/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.maven.plugin.andromdapp;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.andromda.core.common.ResourceUtils;
import org.andromda.maven.plugin.andromdapp.BeanProperties;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.filtering.PropertyUtils;
import org.codehaus.plexus.util.InterpolationFilterReader;

public abstract class AbstractAndroMDAppMojo
extends AbstractMojo {
    private String configurationUri;
    private MavenProject project;
    protected Settings settings;
    protected List<String> propertyFiles;
    protected boolean skip;
    protected boolean skipTests;
    protected boolean testFailureIgnore;
    protected boolean skipProcessing = false;
    private static final String BEGIN_TOKEN = "$${";
    private static final String END_TOKEN = "}";

    private Properties getProperties() throws IOException {
        Properties properties = new Properties();
        properties.put("settings", this.settings);
        properties.putAll((Map<?, ?>)this.project.getProperties());
        if (this.propertyFiles != null) {
            for (String propertiesFile : this.propertyFiles) {
                Properties projectProperties = PropertyUtils.loadPropertyFile((File)new File(propertiesFile), (boolean)true, (boolean)true);
                properties.putAll((Map<?, ?>)projectProperties);
            }
        }
        for (Object propertyObject : properties.keySet()) {
            String property = (String)propertyObject;
            String value = this.replaceProperties(properties, ObjectUtils.toString((Object)properties.get(property)));
            properties.put(property, value);
        }
        properties.putAll((Map<?, ?>)System.getProperties());
        return properties;
    }

    protected String replaceProperties(String string) throws IOException {
        return this.replaceProperties(this.getProperties(), string);
    }

    protected String getConfigurationContents() throws MojoExecutionException, IOException {
        String contents = null;
        if (StringUtils.isNotBlank((String)this.configurationUri)) {
            URL configuration = ResourceUtils.toURL((String)this.configurationUri);
            if (configuration == null) {
                throw new MojoExecutionException("No configuration could be loaded from --> '" + this.configurationUri + '\'');
            }
            contents = this.replaceProperties(ResourceUtils.getContents((URL)configuration));
        }
        return contents;
    }

    private String replaceProperties(Properties properties, String string) throws IOException {
        StringReader stringReader = new StringReader(string);
        InterpolationFilterReader reader = new InterpolationFilterReader((Reader)stringReader, (Map)properties, "${", END_TOKEN);
        reader.reset();
        reader = new InterpolationFilterReader((Reader)reader, (Map)new BeanProperties(this.project), BEGIN_TOKEN, END_TOKEN);
        reader = new InterpolationFilterReader((Reader)reader, (Map)new BeanProperties(this.project), BEGIN_TOKEN, END_TOKEN);
        return ResourceUtils.getContents((Reader)reader);
    }
}

