/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.maven.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.andromda.maven.plugins:andromda-maven-plugin:3.4", 0);
        this.append(sb, "", 0);
        this.append(sb, "AndroMDA Maven Plugin", 0);
        this.append(sb, "A plugin for running AndroMDA's model processor.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 5 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "export2emf".equals(this.goal)) {
            this.append(sb, "andromda:export2emf", 0);
            this.append(sb, "Exports the MagicDraw project file to EMF XMI (requires valid MagicDraw installation in MD_HOME, but only if target files are not up-to-date)", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "allowMultipleRuns (Default: false)", 2);
                this.append(sb, "Do we allow the code generation to run multiple times? Yes for AndroMDA server, no for all other cases unless overridden. This prevents multiple code generation runs while creating site documentation, generate-sources phase can run more than 8 times for each model when initiated by many of the reporting plugins.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "configurationUri", 2);
                this.append(sb, "This is the URI to the AndroMDA configuration file.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: file:${project.basedir}/conf/andromda.xml", 3);
                this.append(sb, "", 0);
                this.append(sb, "magicDrawHome", 2);
                this.append(sb, "The home/root directory of the magicdraw installation.", 3);
                this.append(sb, "Expression: ${magicDrawHome}", 3);
                this.append(sb, "", 0);
                this.append(sb, "propertyFiles", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${project.build.filters}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "andromda:help", 0);
            this.append(sb, "Display help information on andromda-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0andromda:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "run".equals(this.goal)) {
            this.append(sb, "andromda:run", 0);
            this.append(sb, "A Maven2 plugin to run AndroMDA.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "allowMultipleRuns (Default: false)", 2);
                this.append(sb, "Do we allow the code generation to run multiple times? Yes for AndroMDA server, no for all other cases unless overridden. This prevents multiple code generation runs while creating site documentation, generate-sources phase can run more than 8 times for each model when initiated by many of the reporting plugins.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "buildSourceDirectory", 2);
                this.append(sb, "The directory to which the build source is located (any generated source).", 3);
                this.append(sb, "Expression: ${project.build.directory}/src/main/java", 3);
                this.append(sb, "", 0);
                this.append(sb, "configurationUri", 2);
                this.append(sb, "This is the URI to the AndroMDA configuration file.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: file:${project.basedir}/conf/andromda.xml", 3);
                this.append(sb, "", 0);
                this.append(sb, "lastModifiedCheck", 2);
                this.append(sb, "Whether or not a last modified check should be performed before running AndroMDA again. Checks files in buildSourceDirectory against configurationUri and referenced model dates.", 3);
                this.append(sb, "Expression: ${lastModifiedCheck}", 3);
                this.append(sb, "", 0);
                this.append(sb, "modelOutputHistory", 2);
                this.append(sb, "The directory where the model generation output history is located (Modelname file containing a list of files generated by that model).", 3);
                this.append(sb, "Expression: ${project.build.directory}/history", 3);
                this.append(sb, "", 0);
                this.append(sb, "propertyFiles", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${project.build.filters}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipProcessing", 2);
                this.append(sb, "Whether or not processing should be skipped (this is if you just want to force AndroMDA not to run on your model).", 3);
                this.append(sb, "Expression: ${andromda.run.skip}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "start-server".equals(this.goal)) {
            this.append(sb, "andromda:start-server", 0);
            this.append(sb, "Provides the ability to start the AndroMDA server.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "allowMultipleRuns (Default: false)", 2);
                this.append(sb, "Do we allow the code generation to run multiple times? Yes for AndroMDA server, no for all other cases unless overridden. This prevents multiple code generation runs while creating site documentation, generate-sources phase can run more than 8 times for each model when initiated by many of the reporting plugins.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "configurationUri", 2);
                this.append(sb, "This is the URI to the AndroMDA configuration file.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: file:${project.basedir}/conf/andromda.xml", 3);
                this.append(sb, "", 0);
                this.append(sb, "propertyFiles", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${project.build.filters}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "stop-server".equals(this.goal)) {
            this.append(sb, "andromda:stop-server", 0);
            this.append(sb, "Provides the ability to stop the AndroMDA server.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "allowMultipleRuns (Default: false)", 2);
                this.append(sb, "Do we allow the code generation to run multiple times? Yes for AndroMDA server, no for all other cases unless overridden. This prevents multiple code generation runs while creating site documentation, generate-sources phase can run more than 8 times for each model when initiated by many of the reporting plugins.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "configurationUri", 2);
                this.append(sb, "This is the URI to the AndroMDA configuration file.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: file:${project.basedir}/conf/andromda.xml", 3);
                this.append(sb, "", 0);
                this.append(sb, "propertyFiles", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${project.build.filters}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

