/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.security;

import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.management.InvalidDescriptorException;
import net.timewalker.ffmq4.security.Privilege;
import net.timewalker.ffmq4.security.SecurityContext;
import net.timewalker.ffmq4.utils.Checkable;
import net.timewalker.ffmq4.utils.StringTools;

public class User
implements SecurityContext,
Checkable {
    private String name;
    private String password;
    private List<Privilege> privileges = new ArrayList<Privilege>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void addPrivilege(Privilege privilege) {
        this.privileges.add(privilege);
    }

    public void checkPermission(String resourceName, String action) throws JMSException {
        for (int i = 0; i < this.privileges.size(); ++i) {
            Privilege privilege = this.privileges.get(i);
            if (!privilege.matches(resourceName, action)) continue;
            return;
        }
        throw new FFMQException("Access denied to resource '" + resourceName + "' for action '" + action + "'", "ACCESS_DENIED");
    }

    public void check() throws JMSException {
        if (StringTools.isEmpty((String)this.name)) {
            throw new InvalidDescriptorException("Missing user name in security descriptor");
        }
        if (this.password == null) {
            throw new InvalidDescriptorException("Missing password definition for user " + this.name);
        }
    }
}

