/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.jmx.rmi;

import java.net.InetAddress;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.jmx.AbstractJMXAgent;
import net.timewalker.ffmq4.jmx.rmi.JMXOverRMIServerSocketFactory;

public final class JMXOverRMIAgent
extends AbstractJMXAgent {
    private String agentName;
    private int jndiRmiPort;
    private String rmiListenAddr;
    private JMXConnectorServer connectorServer;
    private JMXOverRMIServerSocketFactory mBeanServerSocketFactory;
    private Registry registry;

    public JMXOverRMIAgent(String agentName, int jndiRmiPort, String rmiListenAddr) throws JMSException {
        this.agentName = agentName;
        this.jndiRmiPort = jndiRmiPort;
        this.rmiListenAddr = rmiListenAddr;
        this.init();
    }

    private void init() throws JMSException {
        try {
            if (this.rmiListenAddr == null || this.rmiListenAddr.equals("auto")) {
                this.rmiListenAddr = InetAddress.getLocalHost().getHostName();
            }
            String jndiName = "jmxconnector-" + this.agentName;
            try {
                this.registry = LocateRegistry.getRegistry(this.rmiListenAddr, this.jndiRmiPort);
                this.registry.lookup(jndiName);
                this.registry.unbind(jndiName);
                this.log.debug((Object)("RMI registry found at " + this.rmiListenAddr + ":" + this.jndiRmiPort + " with connector already registered"));
            }
            catch (NotBoundException e) {
                this.log.debug((Object)("RMI registry found at " + this.rmiListenAddr + ":" + this.jndiRmiPort));
            }
            catch (RemoteException e) {
                this.log.debug((Object)("Creating RMI registry at " + this.rmiListenAddr + ":" + this.jndiRmiPort));
                JMXOverRMIServerSocketFactory ssf = new JMXOverRMIServerSocketFactory(10, this.rmiListenAddr, false);
                this.registry = LocateRegistry.createRegistry(this.jndiRmiPort, null, ssf);
            }
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://" + this.rmiListenAddr + "/jndi/rmi://" + this.rmiListenAddr + ":" + this.jndiRmiPort + "/" + jndiName);
            this.log.info((Object)("JMX Service URL : " + url));
            HashMap<String, Object> env = new HashMap<String, Object>();
            this.mBeanServerSocketFactory = new JMXOverRMIServerSocketFactory(10, this.rmiListenAddr, true);
            env.put("jmx.remote.jndi.rebind", "true");
            env.put("jmx.remote.rmi.server.socket.factory", this.mBeanServerSocketFactory);
            this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, env, this.mBeanServer);
            this.connectorServer.start();
        }
        catch (Exception e) {
            throw new FFMQException("Could not initialize JMX agent", "JMX_ERROR", (Throwable)e);
        }
    }

    @Override
    protected String getType() {
        return "RMI";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        if (this.connectorServer != null) {
            try {
                this.connectorServer.stop();
            }
            catch (Exception e) {
                this.log.error((Object)"Could not stop JMX connector server", (Throwable)e);
            }
            finally {
                this.connectorServer = null;
            }
        }
        if (this.registry != null) {
            try {
                String jndiName = "jmxconnector-" + this.agentName;
                this.registry.unbind(jndiName);
            }
            catch (Exception jndiName) {
            }
            finally {
                this.registry = null;
            }
        }
        if (this.mBeanServerSocketFactory != null) {
            try {
                this.mBeanServerSocketFactory.close();
            }
            catch (Exception e) {
                this.log.error((Object)"Could not close MBeans server socket factory", (Throwable)e);
            }
            finally {
                this.mBeanServerSocketFactory = null;
            }
        }
    }
}

