/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4;

import java.util.Properties;
import net.timewalker.ffmq4.FFMQJMXConsole;
import net.timewalker.ffmq4.utils.Settings;

public final class FFMQJMXConsoleLauncher {
    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                FFMQJMXConsoleLauncher.printUsage();
            } else {
                Settings settings = FFMQJMXConsoleLauncher.parseCommandLine(args);
                if (settings != null) {
                    new FFMQJMXConsole(settings, System.in, System.out, System.err).run();
                }
            }
            System.exit(0);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-2);
        }
    }

    private static void printUsage() {
        System.out.println(" Command-line parameters");
        System.out.println("-------------------------");
        System.out.println("  -host <hostname or address> : the target server host");
        System.out.println("  -port <portNumber> : the target server JMX port (default: 10003)");
        System.out.println("  -command <commandName> : the command to run");
        System.out.println("  -interactive : enable interactive mode");
        System.out.println();
    }

    private static Settings parseCommandLine(String[] args) {
        Properties props = new Properties();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--help") || args[i].equals("-help") || args[i].equals("-h")) {
                FFMQJMXConsoleLauncher.printUsage();
                return null;
            }
            if (args[i].equals("-host")) {
                if (++i == args.length) {
                    throw new IllegalArgumentException("Missing value after parameter " + args[i]);
                }
                props.setProperty("jmx.console.server.host", args[i]);
                continue;
            }
            if (args[i].equals("-port")) {
                if (++i == args.length) {
                    throw new IllegalArgumentException("Missing value after parameter " + args[i]);
                }
                props.setProperty("jmx.console.server.port", args[i]);
                continue;
            }
            if (args[i].equals("-interactive")) {
                props.setProperty("jmx.console.interactive", "true");
                continue;
            }
            if (args[i].equals("-command")) {
                if (++i == args.length) {
                    throw new IllegalArgumentException("Missing value after parameter " + args[i]);
                }
                props.setProperty("jmx.console.command", args[i]);
                continue;
            }
            throw new IllegalArgumentException("Unknown command-line option : " + args[i]);
        }
        return new Settings(props);
    }
}

