/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.utils.id;

import java.net.InetAddress;
import java.util.Random;
import net.timewalker.ffmq4.utils.random.MTRandom;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class UUIDProvider {
    private static final Log log = LogFactory.getLog(UUIDProvider.class);
    private static UUIDProvider instance = null;
    private Random seed;
    private String fixedPart;

    public static synchronized UUIDProvider getInstance() {
        if (instance == null) {
            instance = new UUIDProvider();
        }
        return instance;
    }

    private UUIDProvider() {
        try {
            this.seed = new MTRandom();
            byte[] ifBytes = null;
            InetAddress inetaddress = InetAddress.getLocalHost();
            byte[] byArray = ifBytes = inetaddress != null ? inetaddress.getAddress() : null;
            if (ifBytes == null) {
                log.warn((Object)"Cannot determine localhost address, falling back to random value ...");
                ifBytes = new byte[4];
                this.seed.nextBytes(ifBytes);
            }
            StringBuilder base = new StringBuilder();
            String s = UUIDProvider.hexFormat(UUIDProvider.getInt(ifBytes));
            String s1 = UUIDProvider.hexFormat(this.hashCode());
            base.append("-");
            base.append(s.substring(0, 4));
            base.append("-");
            base.append(s.substring(4));
            base.append("-");
            base.append(s1.substring(0, 4));
            base.append("-");
            base.append(s1.substring(4));
            this.fixedPart = base.toString();
            this.seed.nextInt();
        }
        catch (Exception e) {
            log.fatal((Object)"Could not initialise UUID generator", (Throwable)e);
            throw new IllegalStateException("Could not initialise UUID generator : " + e.getMessage());
        }
    }

    public String getUUID() {
        StringBuilder uuid = new StringBuilder(36);
        int i = (int)System.currentTimeMillis();
        int j = this.seed.nextInt();
        UUIDProvider.hexFormat(i, uuid);
        uuid.append(this.fixedPart);
        UUIDProvider.hexFormat(j, uuid);
        return uuid.toString();
    }

    public String getShortUUID() {
        StringBuilder uuid = new StringBuilder(16);
        int i = (int)System.currentTimeMillis();
        int j = this.seed.nextInt();
        UUIDProvider.hexFormat(i, uuid);
        UUIDProvider.hexFormat(j, uuid);
        return uuid.toString();
    }

    private static int getInt(byte[] abyte0) {
        int i = 0;
        int j = 24;
        int k = 0;
        while (j >= 0) {
            int l = abyte0[k] & 0xFF;
            i += l << j;
            j -= 8;
            ++k;
        }
        return i;
    }

    private static String hexFormat(int i) {
        StringBuilder sb = new StringBuilder(8);
        UUIDProvider.hexFormat(i, sb);
        return sb.toString();
    }

    private static void hexFormat(int i, StringBuilder uuid) {
        String s = Integer.toHexString(i);
        for (int n = 0; n < 8 - s.length(); ++n) {
            uuid.append("0");
        }
        uuid.append(s);
    }
}

