/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.utils;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

public class StringTools {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static boolean isNotEmpty(String text) {
        return text != null && text.length() > 0;
    }

    public static String rightPad(String value, int size, char padChar) {
        if (value.length() >= size) {
            return value;
        }
        StringBuilder result = new StringBuilder(size);
        result.append(value);
        for (int n = 0; n < size - value.length(); ++n) {
            result.append(padChar);
        }
        return result.toString();
    }

    public static boolean startsWith(String text, String prefix, int offset, boolean ignoreCase) {
        if (ignoreCase) {
            return StringTools.startsWithIgnoreCase(text, prefix, offset);
        }
        return text.startsWith(prefix, offset);
    }

    public static boolean startsWithIgnoreCase(String text, String prefix, int offset) {
        int textLen = text.length();
        int prefixLen = prefix.length();
        if (offset < 0 || offset > textLen - prefixLen) {
            return false;
        }
        for (int n = 0; n < prefixLen; ++n) {
            char u2;
            char u1 = Character.toUpperCase(text.charAt(n + offset));
            if (u1 == (u2 = Character.toUpperCase(prefix.charAt(n)))) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(String text, String needle, int fromIndex, boolean ignoreCase) {
        if (ignoreCase) {
            return StringTools.indexOfIgnoreCase(text, needle, fromIndex);
        }
        return text.indexOf(needle, fromIndex);
    }

    public static int indexOfIgnoreCase(String text, String needle, int fromIndex) {
        int textLen = text.length();
        int needleLen = needle.length();
        if (fromIndex >= textLen) {
            return needleLen == 0 ? textLen : -1;
        }
        int i = fromIndex;
        if (i < 0) {
            i = 0;
        }
        if (needleLen == 0) {
            return i;
        }
        char first = Character.toUpperCase(needle.charAt(0));
        int max = textLen - needleLen;
        block0: while (true) {
            char c;
            if (i <= max && (c = Character.toUpperCase(text.charAt(i))) != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + needleLen - 1;
            int k = 1;
            while (j < end) {
                char c2;
                char c1;
                if ((c1 = Character.toUpperCase(text.charAt(j++))) == (c2 = Character.toUpperCase(needle.charAt(k++)))) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static boolean matches(String text, String pattern) {
        return StringTools.matches(text, pattern, false);
    }

    public static boolean matchesIgnoreCase(String text, String pattern) {
        return StringTools.matches(text, pattern, true);
    }

    protected static boolean matches(String text, String pattern, boolean ignoreCase) {
        if (text == null) {
            return false;
        }
        if (pattern.length() == 0) {
            return text.length() == 0;
        }
        int textPos = 0;
        boolean startWithAny = false;
        StringTokenizer st = new StringTokenizer(pattern, "*?", true);
        while (st.hasMoreTokens()) {
            String subPattern = st.nextToken();
            if (subPattern.equals("*")) {
                startWithAny = true;
                continue;
            }
            if (subPattern.equals("?")) {
                if (textPos < text.length()) {
                    ++textPos;
                    continue;
                }
                return false;
            }
            if (startWithAny) {
                if ((textPos = StringTools.indexOf(text, subPattern, textPos, ignoreCase)) == -1) {
                    return false;
                }
                startWithAny = false;
            } else if (!StringTools.startsWith(text, subPattern, textPos, ignoreCase)) {
                return false;
            }
            textPos += subPattern.length();
        }
        return textPos >= text.length() || startWithAny;
    }

    public static String capitalize(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        if (Character.isLowerCase(text.charAt(0))) {
            return Character.toUpperCase(text.charAt(0)) + text.substring(1);
        }
        return text;
    }

    public static String join(Collection<?> objects, String separator) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (Object object : objects) {
            if (count++ > 0) {
                sb.append(separator);
            }
            sb.append(String.valueOf(object));
        }
        return sb.toString();
    }

    public static String join(Object[] objects, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int n = 0; n < objects.length; ++n) {
            if (n > 0) {
                sb.append(separator);
            }
            sb.append(String.valueOf(objects[n]));
        }
        return sb.toString();
    }

    public static String[] split(String str, char separatorChar) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                }
                start = ++i;
                continue;
            }
            match = true;
            ++i;
        }
        if (match) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String formatSize(long size) {
        long gigs;
        if (size == 0L) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        if (size < 0L) {
            size = -size;
            sb.append("-");
        }
        if ((gigs = size / 0x40000000L) > 0L) {
            sb.append(new DecimalFormat("######.###").format((double)size / 1.073741824E9));
            sb.append(" GB");
            return sb.toString();
        }
        long megs = size / 0x100000L;
        if (megs > 0L) {
            sb.append(new DecimalFormat("###.#").format((double)size / 1048576.0));
            sb.append(" MB");
            return sb.toString();
        }
        long kbs = size / 1024L;
        if (kbs > 0L) {
            sb.append(new DecimalFormat("###.#").format((double)size / 1024.0));
            sb.append(" KB");
            return sb.toString();
        }
        sb.append(size);
        sb.append(" B");
        return sb.toString();
    }

    public static String asHex(byte[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        char[] buf = new char[data.length * 2];
        int x = 0;
        for (int i = 0; i < data.length; ++i) {
            buf[x++] = HEX_CHARS[data[i] >>> 4 & 0xF];
            buf[x++] = HEX_CHARS[data[i] & 0xF];
        }
        return new String(buf);
    }
}

