/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.transport.tcp.io;

import java.io.IOException;
import java.io.InputStream;
import net.timewalker.ffmq4.transport.PacketTransportException;
import net.timewalker.ffmq4.transport.PacketTransportListener;
import net.timewalker.ffmq4.transport.packet.AbstractPacket;
import net.timewalker.ffmq4.transport.packet.PacketSerializer;
import net.timewalker.ffmq4.transport.tcp.io.AbstractTcpPacketHandler;
import net.timewalker.ffmq4.transport.tcp.io.NetworkInputChannel;
import net.timewalker.ffmq4.transport.tcp.io.TcpPacketTransport;
import net.timewalker.ffmq4.utils.RawDataBuffer;
import net.timewalker.ffmq4.utils.watchdog.ActivityWatchdog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TcpPacketReceiver
extends AbstractTcpPacketHandler
implements Runnable {
    private static final Log log = LogFactory.getLog(TcpPacketReceiver.class);
    private TcpPacketTransport transport;
    private NetworkInputChannel inChannel;
    private int pingInterval;
    private int maxPacketSize;
    private boolean traceEnabled;
    private boolean stopRequired = false;
    private boolean trustedConnection = false;

    protected TcpPacketReceiver(TcpPacketTransport transport, NetworkInputChannel inputChannel, PacketTransportListener listener, int pingInterval, int maxPacketSize) {
        super(transport.getId(), listener);
        this.transport = transport;
        this.pingInterval = pingInterval;
        this.inChannel = inputChannel;
        this.maxPacketSize = maxPacketSize;
        this.traceEnabled = log.isTraceEnabled();
    }

    @Override
    public void run() {
        try {
            if (this.pingInterval > 0) {
                ActivityWatchdog.getInstance().register(this);
            }
            while (!this.stopRequired) {
                AbstractPacket packet;
                int actualMaxPacketSize = Integer.MAX_VALUE;
                if (this.maxPacketSize != -1) {
                    int n = actualMaxPacketSize = this.trustedConnection ? this.maxPacketSize : 1024;
                }
                if ((packet = this.receive(actualMaxPacketSize)) == null) {
                    if (!this.stopRequired) {
                        log.debug((Object)("#" + this.id + " connection closed by remote peer."));
                        this.transport.closeTransport(true);
                    }
                    break;
                }
                if (this.traceEnabled) {
                    log.trace((Object)("#" + this.id + " Received " + packet));
                }
                this.lastActivity = System.currentTimeMillis();
                if (this.listener == null) continue;
                this.trustedConnection = this.listener.packetReceived(packet);
            }
        }
        catch (Exception e) {
            if (!this.stopRequired) {
                log.error((Object)("#" + this.id + " transport failed : " + e.toString()));
                this.transport.closeTransport(true);
            }
        }
        catch (Throwable e) {
            log.fatal((Object)("#" + this.id + " TCP packet receiver died"), e);
        }
        log.debug((Object)("#" + this.id + " stopping."));
    }

    @Override
    public long getTimeoutDelay() {
        return (long)this.pingInterval * 1000L * 2L;
    }

    @Override
    public boolean onActivityTimeout() throws Exception {
        log.warn((Object)("#" + this.id + " ping timeout on client connection, closing socket."));
        this.transport.closeSocket();
        return true;
    }

    public void pleaseStop() {
        this.stopRequired = true;
        if (this.pingInterval > 0) {
            ActivityWatchdog.getInstance().unregister(this);
        }
    }

    public AbstractPacket receive(int maxPacketSize) throws PacketTransportException {
        RawDataBuffer buffer = this.inChannel.ioBuffer;
        buffer.clear();
        int responseSize = this.receiveSize(this.inChannel.stream);
        if (responseSize == -1) {
            return null;
        }
        if (responseSize > maxPacketSize) {
            throw new PacketTransportException("Packet is too large : " + responseSize + " (maxPacketSize=" + maxPacketSize + "), dropping client.");
        }
        if (!this.receiveData(this.inChannel.ioBuffer, this.inChannel.stream, responseSize)) {
            return null;
        }
        buffer.reset();
        try {
            return PacketSerializer.unserializeFrom(buffer);
        }
        catch (Exception e) {
            log.error((Object)"Cannot unserialize packet", (Throwable)e);
            return null;
        }
    }

    private int receiveSize(InputStream in) {
        try {
            int ch1 = in.read();
            int ch2 = in.read();
            int ch3 = in.read();
            int ch4 = in.read();
            if ((ch1 | ch2 | ch3 | ch4) < 0) {
                return -1;
            }
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        }
        catch (IOException e) {
            return -1;
        }
    }

    private boolean receiveData(RawDataBuffer buffer, InputStream in, int amount) throws PacketTransportException {
        try {
            int readAmount;
            buffer.ensureCapacity(amount);
            for (int received = 0; received < amount; received += readAmount) {
                readAmount = buffer.readFrom(in, received, amount - received);
                if (readAmount > 0) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            throw new PacketTransportException("Connection read error", e);
        }
    }
}

