/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.transport.tcp.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class TcpBufferedOutputStream
extends FilterOutputStream {
    private byte[] buffer;
    private int capacity;
    private int size;

    public TcpBufferedOutputStream(OutputStream out, int capacity) {
        super(out);
        this.buffer = new byte[capacity];
        this.capacity = capacity;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.capacity - this.size < 1) {
            this.flush();
        }
        this.buffer[this.size++] = (byte)b;
    }

    @Override
    public void write(byte[] data, int offset, int len) throws IOException {
        if (this.capacity - this.size < len) {
            this.flush();
        }
        if (this.capacity >= len) {
            System.arraycopy(data, offset, this.buffer, this.size, len);
            this.size += len;
        } else {
            this.out.write(data, offset, len);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.size > 0) {
            this.out.write(this.buffer, 0, this.size);
            this.size = 0;
        }
    }
}

