/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.transport.packet.query;

import javax.jms.Destination;
import javax.jms.Topic;
import net.timewalker.ffmq4.common.destination.DestinationSerializer;
import net.timewalker.ffmq4.transport.packet.query.AbstractSessionQuery;
import net.timewalker.ffmq4.utils.RawDataBuffer;
import net.timewalker.ffmq4.utils.id.IntegerID;

public final class CreateDurableSubscriberQuery
extends AbstractSessionQuery {
    private IntegerID consumerId;
    private Topic topic;
    private String messageSelector;
    private boolean noLocal;
    private String name;

    @Override
    public byte getType() {
        return 11;
    }

    @Override
    protected void serializeTo(RawDataBuffer out) {
        super.serializeTo(out);
        out.writeInt(this.consumerId.asInt());
        DestinationSerializer.serializeTo((Destination)this.topic, out);
        out.writeNullableUTF(this.messageSelector);
        out.writeBoolean(this.noLocal);
        out.writeUTF(this.name);
    }

    @Override
    protected void unserializeFrom(RawDataBuffer in) {
        super.unserializeFrom(in);
        this.consumerId = new IntegerID(in.readInt());
        this.topic = (Topic)DestinationSerializer.unserializeFrom(in);
        this.messageSelector = in.readNullableUTF();
        this.noLocal = in.readBoolean();
        this.name = in.readUTF();
    }

    public IntegerID getConsumerId() {
        return this.consumerId;
    }

    public void setConsumerId(IntegerID consumerId) {
        this.consumerId = consumerId;
    }

    public Topic getTopic() {
        return this.topic;
    }

    public void setTopic(Topic topic) {
        this.topic = topic;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" consumerId=");
        sb.append(this.consumerId);
        sb.append(" topic=");
        sb.append(this.topic);
        sb.append(" messageSelector=[");
        sb.append(this.messageSelector);
        sb.append("] noLocal=");
        sb.append(this.noLocal);
        sb.append(" name=");
        sb.append(this.name);
        return sb.toString();
    }
}

