/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.transport;

import java.util.Hashtable;
import java.util.Map;
import javax.jms.JMSException;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.transport.PacketTransport;
import net.timewalker.ffmq4.transport.PacketTransportEndpoint;
import net.timewalker.ffmq4.transport.packet.AbstractResponsePacket;

public final class PacketTransportHub {
    private PacketTransport transport;
    private Map<Integer, PacketTransportEndpoint> registeredEndpoints = new Hashtable<Integer, PacketTransportEndpoint>();
    private boolean closed;
    private int nextEndpointId;

    public PacketTransportHub(PacketTransport transport) {
        this.transport = transport;
    }

    public PacketTransport getTransport() {
        return this.transport;
    }

    public synchronized PacketTransportEndpoint createEndpoint() throws JMSException {
        if (this.closed || this.transport.isClosed()) {
            throw new FFMQException("Transport is closed", "TRANSPORT_CLOSED");
        }
        PacketTransportEndpoint endpoint = new PacketTransportEndpoint(this.nextEndpointId++, this);
        this.registeredEndpoints.put(endpoint.getId(), endpoint);
        return endpoint;
    }

    protected void unregisterEndpoint(PacketTransportEndpoint endpoint) {
        this.registeredEndpoints.remove(endpoint.getId());
    }

    public void routeResponse(AbstractResponsePacket response) {
        int endpointId = response.getEndpointId();
        if (endpointId == -1) {
            return;
        }
        PacketTransportEndpoint endpoint = this.registeredEndpoints.get(endpointId);
        if (endpoint == null) {
            return;
        }
        endpoint.setResponse(response);
        endpoint.getResponseSemaphore().release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Map<Integer, PacketTransportEndpoint> map = this.registeredEndpoints;
        synchronized (map) {
            for (PacketTransportEndpoint endpoint : this.registeredEndpoints.values()) {
                endpoint.getResponseSemaphore().release();
            }
            this.registeredEndpoints.clear();
        }
    }
}

