/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.storage.data.impl.journal;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import net.timewalker.ffmq4.storage.data.impl.journal.AbstractJournalOperation;
import net.timewalker.ffmq4.storage.data.impl.journal.CommitOperation;
import net.timewalker.ffmq4.storage.data.impl.journal.DataBlockWriteOperation;
import net.timewalker.ffmq4.storage.data.impl.journal.JournalException;
import net.timewalker.ffmq4.storage.data.impl.journal.MetaDataBlockWriteOperation;
import net.timewalker.ffmq4.storage.data.impl.journal.MetaDataWriteOperation;
import net.timewalker.ffmq4.storage.data.impl.journal.StoreExtendOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JournalRecovery {
    private static final Log log = LogFactory.getLog(JournalRecovery.class);
    private String baseName;
    private File[] journalFiles;
    private RandomAccessFile allocationTableRandomAccessFile;
    private RandomAccessFile dataRandomAccessFile;

    public JournalRecovery(String baseName, File[] journalFiles, RandomAccessFile allocationTableRandomAccessFile, RandomAccessFile dataRandomAccessFile) {
        this.baseName = baseName;
        this.journalFiles = journalFiles;
        this.allocationTableRandomAccessFile = allocationTableRandomAccessFile;
        this.dataRandomAccessFile = dataRandomAccessFile;
    }

    public int recover() throws JournalException {
        int newBlockCount = -1;
        log.warn((Object)("[" + this.baseName + "] Recovery required for data store : found " + this.journalFiles.length + " journal file(s)"));
        for (int i = 0; i < this.journalFiles.length; ++i) {
            newBlockCount = this.recoverFromJournalFile(this.journalFiles[i]);
        }
        return newBlockCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int recoverFromJournalFile(File journalFile) throws JournalException {
        DataInputStream in;
        log.debug((Object)("[" + this.baseName + "] Processing " + journalFile.getAbsolutePath()));
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(journalFile)));
        }
        catch (IOException e) {
            throw new JournalException("Cannot open journal file : " + journalFile.getAbsolutePath(), e);
        }
        int replayedOperations = 0;
        int replayedTransactions = 0;
        long currentTransactionId = -1L;
        int newBlockCount = -1;
        LinkedList<AbstractJournalOperation> transactionQueue = new LinkedList<AbstractJournalOperation>();
        try {
            AbstractJournalOperation op;
            while ((op = JournalRecovery.readJournalOperation(in)) != null) {
                if (currentTransactionId == -1L) {
                    currentTransactionId = op.getTransactionId();
                } else if (currentTransactionId != op.getTransactionId()) {
                    throw new IllegalStateException("Transaction id inconsistency : " + currentTransactionId + " -> " + op.getTransactionId());
                }
                if (op instanceof CommitOperation) {
                    int opCount = ((CommitOperation)op).getOperationsCount();
                    if (transactionQueue.size() != opCount) {
                        throw new IllegalStateException("Transaction size mismatch (expected " + opCount + ", got " + transactionQueue.size() + ")");
                    }
                    log.trace((Object)("[" + this.baseName + "] Replaying transaction #" + currentTransactionId + " (" + transactionQueue.size() + " operation(s))"));
                    replayedOperations += transactionQueue.size();
                    ++replayedTransactions;
                    newBlockCount = this.applyOperations(transactionQueue);
                    currentTransactionId = -1L;
                    continue;
                }
                transactionQueue.addLast(op);
            }
            if (transactionQueue.size() > 0) {
                op = (AbstractJournalOperation)transactionQueue.removeFirst();
                log.warn((Object)("[" + this.baseName + "] Dropping incomplete transaction : #" + op.getTransactionId()));
            }
            this.syncStore();
            log.warn((Object)("[" + this.baseName + "] Recovery complete. (Replayed " + replayedTransactions + " transaction(s) and " + replayedOperations + " operation(s))"));
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new JournalException("Cannot close journal file : " + journalFile.getAbsolutePath(), e);
            }
        }
        return newBlockCount;
    }

    private int applyOperations(LinkedList<AbstractJournalOperation> transactionQueue) throws JournalException {
        int newBlockCount = -1;
        while (transactionQueue.size() > 0) {
            AbstractJournalOperation op = transactionQueue.removeFirst();
            if (op instanceof MetaDataWriteOperation) {
                ((MetaDataWriteOperation)op).writeTo(this.allocationTableRandomAccessFile);
                continue;
            }
            if (op instanceof MetaDataBlockWriteOperation) {
                ((MetaDataBlockWriteOperation)op).writeTo(this.allocationTableRandomAccessFile);
                continue;
            }
            if (op instanceof DataBlockWriteOperation) {
                ((DataBlockWriteOperation)op).writeTo(this.dataRandomAccessFile);
                continue;
            }
            if (op instanceof StoreExtendOperation) {
                newBlockCount = ((StoreExtendOperation)op).extend(this.allocationTableRandomAccessFile, this.dataRandomAccessFile);
                continue;
            }
            throw new IllegalArgumentException("Unexpected journal operation : " + op);
        }
        return newBlockCount;
    }

    private void syncStore() throws JournalException {
        try {
            this.allocationTableRandomAccessFile.getFD().sync();
        }
        catch (IOException e) {
            log.error((Object)("[" + this.baseName + "] Could not sync store allocation table file"), (Throwable)e);
            throw new JournalException("Could not sync store allocation table file");
        }
        try {
            this.dataRandomAccessFile.getFD().sync();
        }
        catch (IOException e) {
            log.error((Object)("[" + this.baseName + "] Could not sync store data file"), (Throwable)e);
            throw new JournalException("Could not sync store data file");
        }
    }

    public static AbstractJournalOperation readJournalOperation(DataInputStream in) {
        try {
            int operationType = in.read();
            if (operationType == -1) {
                return null;
            }
            switch (operationType) {
                case 0: {
                    return null;
                }
                case 2: {
                    return JournalRecovery.readMetaDataWriteOperation(in);
                }
                case 3: {
                    return JournalRecovery.readMetaDataBlockWriteOperation(in);
                }
                case 1: {
                    return JournalRecovery.readDataBlockWriteOperation(in);
                }
                case 4: {
                    return JournalRecovery.readStoreExtendOperation(in);
                }
                case 5: {
                    return JournalRecovery.readCommitOperation(in);
                }
            }
            throw new IllegalArgumentException("Invalid operation type : " + operationType);
        }
        catch (Exception e) {
            log.error((Object)"Corrupted or truncated journal operation, skipping.", (Throwable)e);
            return null;
        }
    }

    private static MetaDataWriteOperation readMetaDataWriteOperation(DataInputStream in) throws IOException {
        long transactionId = in.readLong();
        long metaDataOffset = in.readLong();
        int metaData = in.readInt();
        return new MetaDataWriteOperation(transactionId, metaDataOffset, metaData);
    }

    private static MetaDataBlockWriteOperation readMetaDataBlockWriteOperation(DataInputStream in) throws IOException {
        long transactionId = in.readLong();
        long metaDataOffset = in.readLong();
        int len = in.readInt();
        byte[] metaData = new byte[len];
        in.readFully(metaData);
        return new MetaDataBlockWriteOperation(transactionId, metaDataOffset, metaData);
    }

    private static DataBlockWriteOperation readDataBlockWriteOperation(DataInputStream in) throws IOException {
        long transactionId = in.readLong();
        long blockOffset = in.readLong();
        int len = in.readInt();
        byte[] dataBlock = new byte[len];
        in.readFully(dataBlock);
        return new DataBlockWriteOperation(transactionId, -1, blockOffset, dataBlock);
    }

    private static StoreExtendOperation readStoreExtendOperation(DataInputStream in) throws IOException {
        long transactionId = in.readLong();
        int blockSize = in.readInt();
        int oldBlockCount = in.readInt();
        int newBlockCount = in.readInt();
        return new StoreExtendOperation(transactionId, blockSize, oldBlockCount, newBlockCount);
    }

    private static CommitOperation readCommitOperation(DataInputStream in) throws IOException {
        long transactionId = in.readLong();
        int operationsCount = in.readInt();
        return new CommitOperation(transactionId, operationsCount, null);
    }
}

