/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.storage.data.impl.journal;

import net.timewalker.ffmq4.storage.data.impl.journal.JournalException;
import net.timewalker.ffmq4.storage.data.impl.journal.JournalFile;

public abstract class AbstractJournalOperation {
    public static final byte TYPE_DATA_BLOCK_WRITE = 1;
    public static final byte TYPE_META_DATA_WRITE = 2;
    public static final byte TYPE_META_DATA_BLOCK_WRITE = 3;
    public static final byte TYPE_STORE_EXTEND = 4;
    public static final byte TYPE_COMMIT = 5;
    private long transactionId;
    private byte type;
    private AbstractJournalOperation next;

    public AbstractJournalOperation(long transactionId, byte type) {
        this.transactionId = transactionId;
        this.type = type;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public final byte getType() {
        return this.type;
    }

    public int size() {
        return 9;
    }

    protected void writeTo(JournalFile journalFile) throws JournalException {
        journalFile.writeByte(this.type);
        journalFile.writeLong(this.transactionId);
    }

    public AbstractJournalOperation next() {
        return this.next;
    }

    public void setNext(AbstractJournalOperation next) {
        this.next = next;
    }

    public String toString() {
        return "#" + this.transactionId;
    }
}

