/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.storage.data.impl;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Comparator;
import net.timewalker.ffmq4.storage.data.DataStoreException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlockBasedDataStoreTools {
    private static final Log log = LogFactory.getLog(BlockBasedDataStoreTools.class);
    private static final byte[] EMPTY_BLOCK = new byte[]{0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    public static void create(String baseName, File dataFolder, int blockCount, int blockSize, boolean forceSync) throws DataStoreException {
        if (blockCount <= 0) {
            throw new DataStoreException("Block count should be > 0");
        }
        if (blockSize <= 0) {
            throw new DataStoreException("Block size should be > 0");
        }
        File atFile = new File(dataFolder, baseName + ".index");
        File dataFile = new File(dataFolder, baseName + ".store");
        if (atFile.exists()) {
            throw new DataStoreException("Cannot create store filesystem : " + atFile.getAbsolutePath() + " already exists");
        }
        if (dataFile.exists()) {
            throw new DataStoreException("Cannot create store filesystem : " + dataFile.getAbsolutePath() + " already exists");
        }
        BlockBasedDataStoreTools.initAllocationTable(atFile, blockCount, blockSize, forceSync);
        BlockBasedDataStoreTools.initDataFile(dataFile, blockCount, blockSize, forceSync);
    }

    private static void initAllocationTable(File atFile, int blockCount, int blockSize, boolean forceSync) throws DataStoreException {
        log.debug((Object)("Creating allocation table (size=" + blockCount + ") ..."));
        try {
            FileOutputStream outFile = new FileOutputStream(atFile);
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(outFile));
            out.writeInt(blockCount);
            out.writeInt(blockSize);
            out.writeInt(-1);
            for (int n = 0; n < blockCount; ++n) {
                out.write(EMPTY_BLOCK);
            }
            out.flush();
            if (forceSync) {
                outFile.getFD().sync();
            }
            out.close();
        }
        catch (IOException e) {
            throw new DataStoreException("Cannot initialize allocation table " + atFile.getAbsolutePath(), e);
        }
    }

    private static void initDataFile(File dataFile, int blockCount, int blockSize, boolean forceSync) throws DataStoreException {
        log.debug((Object)("Creating an empty map file (size=" + blockCount + "x" + blockSize + ") ..."));
        try {
            RandomAccessFile dataFileMap = new RandomAccessFile(dataFile, "rw");
            dataFileMap.setLength((long)blockSize * (long)blockCount);
            if (forceSync) {
                dataFileMap.getFD().sync();
            }
            dataFileMap.close();
        }
        catch (IOException e) {
            throw new DataStoreException("Cannot initialize map file " + dataFile.getAbsolutePath(), e);
        }
    }

    public static void delete(String baseName, File dataFolder, boolean force) throws DataStoreException {
        File atFile;
        File[] journalFiles = BlockBasedDataStoreTools.findJournalFiles(baseName, dataFolder);
        if (journalFiles.length > 0) {
            if (force) {
                for (int i = 0; i < journalFiles.length; ++i) {
                    if (journalFiles[i].delete()) continue;
                    throw new DataStoreException("Cannot delete file : " + journalFiles[i].getAbsolutePath());
                }
            } else {
                throw new DataStoreException("Journal file exist : " + journalFiles[0].getAbsolutePath());
            }
        }
        if ((atFile = new File(dataFolder, baseName + ".index")).exists() && !atFile.delete()) {
            throw new DataStoreException("Cannot delete file : " + atFile.getAbsolutePath());
        }
        File dataFile = new File(dataFolder, baseName + ".store");
        if (dataFile.exists() && !dataFile.delete()) {
            throw new DataStoreException("Cannot delete file : " + dataFile.getAbsolutePath());
        }
    }

    public static File[] findJournalFiles(String baseName, File dataFolder) {
        final String journalBase = baseName + ".journal";
        File[] journalFiles = dataFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (!pathname.isFile()) {
                    return false;
                }
                return pathname.getName().startsWith(journalBase) && !pathname.getName().endsWith(".recycled");
            }
        });
        Arrays.sort(journalFiles, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
        return journalFiles;
    }

    public static File[] findRecycledJournalFiles(String baseName, File dataFolder) {
        final String journalBase = baseName + ".journal";
        File[] recycledFiles = dataFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (!pathname.isFile()) {
                    return false;
                }
                return pathname.getName().startsWith(journalBase) && pathname.getName().endsWith(".recycled");
            }
        });
        return recycledFiles;
    }
}

