/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.management.destination.template;

import java.util.StringTokenizer;
import javax.jms.JMSException;
import net.timewalker.ffmq4.FFMQSubscriberPolicy;
import net.timewalker.ffmq4.common.message.selector.expression.utils.StringUtils;
import net.timewalker.ffmq4.management.InvalidDescriptorException;
import net.timewalker.ffmq4.management.destination.definition.TopicDefinition;
import net.timewalker.ffmq4.management.destination.template.AbstractDestinationTemplate;
import net.timewalker.ffmq4.utils.Settings;

public final class TopicTemplate
extends AbstractDestinationTemplate {
    private int subscriberFailurePolicy;
    private int subscriberOverflowPolicy;
    private String[] partitionsKeysToIndex;

    public TopicTemplate() {
    }

    public TopicTemplate(Settings settings) {
        super(settings);
    }

    public void setSubscriberFailurePolicy(int subscriberFailurePolicy) {
        this.subscriberFailurePolicy = subscriberFailurePolicy;
    }

    public void setSubscriberOverflowPolicy(int subscriberOverflowPolicy) {
        this.subscriberOverflowPolicy = subscriberOverflowPolicy;
    }

    public int getSubscriberFailurePolicy() {
        return this.subscriberFailurePolicy;
    }

    public int getSubscriberOverflowPolicy() {
        return this.subscriberOverflowPolicy;
    }

    public String[] getPartitionsKeysToIndex() {
        return this.partitionsKeysToIndex;
    }

    public void setPartitionsKeysToIndex(String[] partitionsKeysToIndex) {
        this.partitionsKeysToIndex = partitionsKeysToIndex;
    }

    @Override
    protected void initFromSettings(Settings settings) {
        super.initFromSettings(settings);
        this.subscriberFailurePolicy = settings.getIntProperty("subscriberFailurePolicy", 1);
        this.subscriberOverflowPolicy = settings.getIntProperty("subscriberOverflowPolicy", 1);
        String rawPartitionsKeysToIndex = settings.getStringProperty("partitionsKeysToIndex");
        if (rawPartitionsKeysToIndex != null) {
            StringTokenizer st = new StringTokenizer(rawPartitionsKeysToIndex, ", ");
            this.partitionsKeysToIndex = new String[st.countTokens()];
            int pos = 0;
            while (st.hasMoreTokens()) {
                this.partitionsKeysToIndex[pos++] = st.nextToken();
            }
        }
    }

    @Override
    protected void fillSettings(Settings settings) {
        super.fillSettings(settings);
        settings.setIntProperty("subscriberFailurePolicy", this.subscriberFailurePolicy);
        settings.setIntProperty("subscriberOverflowPolicy", this.subscriberOverflowPolicy);
        if (this.partitionsKeysToIndex != null) {
            settings.setStringProperty("partitionsKeysToIndex", StringUtils.implode(this.partitionsKeysToIndex, ","));
        }
    }

    public TopicDefinition createTopicDefinition(String topicName, boolean temporary) {
        TopicDefinition def = new TopicDefinition();
        def.setName(topicName);
        def.setTemporary(temporary);
        this.copyAttributesTo(def);
        def.setSubscriberFailurePolicy(this.subscriberFailurePolicy);
        def.setSubscriberOverflowPolicy(this.subscriberOverflowPolicy);
        def.setPartitionsKeysToIndex(this.partitionsKeysToIndex);
        return def;
    }

    @Override
    public void check() throws JMSException {
        super.check();
        if (!FFMQSubscriberPolicy.isValid(this.subscriberFailurePolicy)) {
            throw new InvalidDescriptorException("Invalid subscriber failure policy mask : " + this.subscriberFailurePolicy);
        }
        if (!FFMQSubscriberPolicy.isValid(this.subscriberOverflowPolicy)) {
            throw new InvalidDescriptorException("Invalid subscriber overflow policy mask : " + this.subscriberOverflowPolicy);
        }
        if (this.partitionsKeysToIndex != null) {
            if (this.partitionsKeysToIndex.length == 0) {
                throw new InvalidDescriptorException("Empty partitionsKeysToIndex definition");
            }
            for (String key : this.partitionsKeysToIndex) {
                if (!key.startsWith("JMS") || key.equals("JMSCorrelationID")) continue;
                throw new InvalidDescriptorException("JMSCorrelationID is the only JMS standard header that may be indexed, cannot use " + key);
            }
        }
    }
}

