/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.management.destination.definition;

import java.util.StringTokenizer;
import javax.jms.JMSException;
import net.timewalker.ffmq4.FFMQSubscriberPolicy;
import net.timewalker.ffmq4.common.destination.DestinationTools;
import net.timewalker.ffmq4.common.message.selector.expression.utils.StringUtils;
import net.timewalker.ffmq4.management.InvalidDescriptorException;
import net.timewalker.ffmq4.management.destination.definition.AbstractDestinationDefinition;
import net.timewalker.ffmq4.management.destination.definition.QueueDefinition;
import net.timewalker.ffmq4.utils.Settings;

public final class TopicDefinition
extends AbstractDestinationDefinition {
    private int subscriberFailurePolicy;
    private int subscriberOverflowPolicy;
    private String[] partitionsKeysToIndex;

    public TopicDefinition() {
    }

    public TopicDefinition(Settings settings) {
        super(settings);
    }

    public void setSubscriberFailurePolicy(int subscriberFailurePolicy) {
        this.subscriberFailurePolicy = subscriberFailurePolicy;
    }

    public void setSubscriberOverflowPolicy(int subscriberOverflowPolicy) {
        this.subscriberOverflowPolicy = subscriberOverflowPolicy;
    }

    public int getSubscriberFailurePolicy() {
        return this.subscriberFailurePolicy;
    }

    public int getSubscriberOverflowPolicy() {
        return this.subscriberOverflowPolicy;
    }

    public void setPartitionsKeysToIndex(String[] partitionsKeysToIndex) {
        this.partitionsKeysToIndex = partitionsKeysToIndex;
    }

    public String[] getPartitionsKeysToIndex() {
        return this.partitionsKeysToIndex;
    }

    @Override
    protected void initFromSettings(Settings settings) {
        super.initFromSettings(settings);
        this.subscriberFailurePolicy = settings.getIntProperty("subscriberFailurePolicy", 1);
        this.subscriberOverflowPolicy = settings.getIntProperty("subscriberOverflowPolicy", 1);
        String rawPartitionsKeysToIndex = settings.getStringProperty("partitionsKeysToIndex");
        if (rawPartitionsKeysToIndex != null) {
            StringTokenizer st = new StringTokenizer(rawPartitionsKeysToIndex, ", ");
            this.partitionsKeysToIndex = new String[st.countTokens()];
            int pos = 0;
            while (st.hasMoreTokens()) {
                this.partitionsKeysToIndex[pos++] = st.nextToken();
            }
        }
    }

    @Override
    protected void fillSettings(Settings settings) {
        super.fillSettings(settings);
        settings.setIntProperty("subscriberFailurePolicy", this.subscriberFailurePolicy);
        settings.setIntProperty("subscriberOverflowPolicy", this.subscriberOverflowPolicy);
        if (this.partitionsKeysToIndex != null) {
            settings.setStringProperty("partitionsKeysToIndex", StringUtils.implode(this.partitionsKeysToIndex, ","));
        }
    }

    public QueueDefinition createQueueDefinition(String topicName, String consumerId, boolean temporary) {
        QueueDefinition def = new QueueDefinition();
        def.setName(DestinationTools.getQueueNameForTopicConsumer(topicName, consumerId));
        def.setTemporary(temporary);
        this.copyAttributesTo(def);
        return def;
    }

    public boolean supportDeliveryMode(int deliveryMode) {
        switch (deliveryMode) {
            case 2: {
                return this.initialBlockCount > 0;
            }
            case 1: {
                return this.maxNonPersistentMessages > 0;
            }
        }
        throw new IllegalArgumentException("Invalid delivery mode : " + deliveryMode);
    }

    @Override
    public void check() throws JMSException {
        super.check();
        DestinationTools.checkTopicName(this.name);
        if (!FFMQSubscriberPolicy.isValid(this.subscriberFailurePolicy)) {
            throw new InvalidDescriptorException("Invalid subscriber failure policy mask : " + this.subscriberFailurePolicy);
        }
        if (!FFMQSubscriberPolicy.isValid(this.subscriberOverflowPolicy)) {
            throw new InvalidDescriptorException("Invalid subscriber overflow policy mask : " + this.subscriberOverflowPolicy);
        }
        if (this.partitionsKeysToIndex != null) {
            if (this.partitionsKeysToIndex.length == 0) {
                throw new InvalidDescriptorException("Empty partitionsKeysToIndex definition");
            }
            for (String key : this.partitionsKeysToIndex) {
                if (!key.startsWith("JMS") || key.equals("JMSCorrelationID")) continue;
                throw new InvalidDescriptorException("JMSCorrelationID is the only JMS standard header that may be indexed, cannot use " + key);
            }
        }
    }
}

