/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.management.bridge;

import javax.jms.JMSException;
import net.timewalker.ffmq4.cluster.bridge.JMSBridgeDefinitionMBean;
import net.timewalker.ffmq4.management.InvalidDescriptorException;
import net.timewalker.ffmq4.management.ManagementUtils;
import net.timewalker.ffmq4.management.destination.DestinationReferenceDescriptor;
import net.timewalker.ffmq4.management.peer.PeerDescriptor;
import net.timewalker.ffmq4.utils.descriptor.AbstractXMLBasedDescriptor;

public final class BridgeDefinition
extends AbstractXMLBasedDescriptor
implements JMSBridgeDefinitionMBean {
    private String name;
    private Boolean enabled;
    private Integer retryInterval;
    private Boolean commitSourceFirst;
    private Boolean producerTransacted;
    private Boolean consumerTransacted;
    private int consumerAcknowledgeMode = -1;
    private int producerDeliveryMode = -1;
    private PeerDescriptor source = new PeerDescriptor();
    private PeerDescriptor target = new PeerDescriptor();
    private DestinationReferenceDescriptor sourceDestination = new DestinationReferenceDescriptor();
    private DestinationReferenceDescriptor targetDestination = new DestinationReferenceDescriptor();

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled != null ? this.enabled : false;
    }

    @Override
    public int getRetryInterval() {
        return this.retryInterval != null ? this.retryInterval : 0;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    @Override
    public boolean isCommitSourceFirst() {
        return this.commitSourceFirst != null ? this.commitSourceFirst : false;
    }

    public void setCommitSourceFirst(boolean commitSourceFirst) {
        this.commitSourceFirst = commitSourceFirst;
    }

    public PeerDescriptor getSource() {
        return this.source;
    }

    public PeerDescriptor getTarget() {
        return this.target;
    }

    public DestinationReferenceDescriptor getSourceDestination() {
        return this.sourceDestination;
    }

    public DestinationReferenceDescriptor getTargetDestination() {
        return this.targetDestination;
    }

    public void setProducerTransacted(boolean producerTransacted) {
        this.producerTransacted = producerTransacted;
    }

    @Override
    public boolean isProducerTransacted() {
        return this.producerTransacted != null ? this.producerTransacted : false;
    }

    public void setConsumerTransacted(boolean consumerTransacted) {
        this.consumerTransacted = consumerTransacted;
    }

    @Override
    public boolean isConsumerTransacted() {
        return this.consumerTransacted != null ? this.consumerTransacted : false;
    }

    public void setConsumerAcknowledgeMode(int consumerAcknowledgeMode) {
        this.consumerAcknowledgeMode = consumerAcknowledgeMode;
    }

    public void setConsumerAcknowledgeMode(String consumerAcknowledgeMode) {
        this.consumerAcknowledgeMode = ManagementUtils.parseAcknowledgeMode(consumerAcknowledgeMode);
    }

    @Override
    public int getConsumerAcknowledgeMode() {
        return this.consumerAcknowledgeMode;
    }

    @Override
    public int getProducerDeliveryMode() {
        return this.producerDeliveryMode;
    }

    public void setProducerDeliveryMode(int producerDeliveryMode) {
        this.producerDeliveryMode = producerDeliveryMode;
    }

    public void setProducerDeliveryMode(String producerDeliveryMode) {
        this.producerDeliveryMode = ManagementUtils.parseDeliveryMode(producerDeliveryMode);
    }

    @Override
    public void check() throws JMSException {
        if (this.name == null) {
            throw new InvalidDescriptorException("Missing bridge property : 'name'");
        }
        if (this.enabled == null) {
            throw new InvalidDescriptorException("Missing bridge property : 'enabled'");
        }
        if (this.retryInterval == null) {
            throw new InvalidDescriptorException("Missing bridge property : 'retryInterval'");
        }
        if (this.getRetryInterval() < 0) {
            throw new InvalidDescriptorException("Bridge property 'retryInterval' should be >= 0");
        }
        if (this.commitSourceFirst == null) {
            throw new InvalidDescriptorException("Missing bridge property : 'commitSourceFirst'");
        }
        if (this.producerTransacted == null) {
            throw new InvalidDescriptorException("Missing bridge property : 'producerTransacted'");
        }
        if (this.consumerTransacted == null) {
            throw new InvalidDescriptorException("Missing bridge property : 'consumerTransacted'");
        }
        if (!this.isConsumerTransacted() && this.consumerAcknowledgeMode == -1) {
            throw new InvalidDescriptorException("Missing bridge property : 'consumerAcknowledgeMode'");
        }
        if (this.producerDeliveryMode == -1) {
            throw new InvalidDescriptorException("Missing bridge property : 'producerDeliveryMode'");
        }
        this.source.check();
        this.target.check();
        this.sourceDestination.check();
        this.targetDestination.check();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.name);
        sb.append("] retryInterval=");
        sb.append(this.retryInterval);
        sb.append(" commitSourceFirst=");
        sb.append(this.commitSourceFirst);
        sb.append(" producerTransacted=");
        sb.append(this.producerTransacted);
        sb.append(" consumerTransacted=");
        sb.append(this.consumerTransacted);
        sb.append(" consumerAcknowledgeMode=");
        sb.append(this.consumerAcknowledgeMode);
        sb.append(" producerDeliveryMode=");
        sb.append(this.producerDeliveryMode);
        sb.append(" source=(");
        sb.append(this.source);
        sb.append(") target=(");
        sb.append(this.target);
        sb.append(") sourceDestination=(");
        sb.append(this.sourceDestination);
        sb.append(") targetDestination=(");
        sb.append(this.targetDestination);
        sb.append(")");
        return sb.toString();
    }
}

