/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.local.session;

import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import net.timewalker.ffmq4.local.FFMQEngine;
import net.timewalker.ffmq4.local.connection.LocalQueueConnection;
import net.timewalker.ffmq4.local.session.LocalQueueReceiver;
import net.timewalker.ffmq4.local.session.LocalQueueSender;
import net.timewalker.ffmq4.local.session.LocalSession;
import net.timewalker.ffmq4.utils.id.IntegerID;

public final class LocalQueueSession
extends LocalSession
implements QueueSession {
    public LocalQueueSession(IntegerID id, LocalQueueConnection connection, FFMQEngine engine, boolean transacted, int acknowlegdeMode) {
        super(id, connection, engine, transacted, acknowlegdeMode);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this.createReceiver(queue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            LocalQueueReceiver receiver = new LocalQueueReceiver(this.engine, this, queue, messageSelector, this.idProvider.createID());
            this.registerConsumer(receiver);
            receiver.initDestination();
            LocalQueueReceiver localQueueReceiver = receiver;
            return localQueueReceiver;
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueSender createSender(Queue queue) throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            LocalQueueSender sender = new LocalQueueSender((LocalSession)this, queue, this.idProvider.createID());
            this.registerProducer(sender);
            LocalQueueSender localQueueSender = sender;
            return localQueueSender;
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        throw new IllegalStateException("Method not available on this domain.");
    }

    @Override
    public TopicSubscriber createDurableSubscriber(Topic topic, String subscriptionName, String messageSelector, boolean noLocal) throws JMSException {
        throw new IllegalStateException("Method not available on this domain.");
    }

    @Override
    public TemporaryTopic createTemporaryTopic() throws JMSException {
        throw new IllegalStateException("Method not available on this domain.");
    }

    @Override
    public Topic createTopic(String topicName) throws JMSException {
        throw new IllegalStateException("Method not available on this domain.");
    }

    @Override
    public void unsubscribe(String subscriptionName) throws JMSException {
        throw new IllegalStateException("Method not available on this domain.");
    }
}

