/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.local.session;

import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Topic;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.common.message.AbstractMessage;
import net.timewalker.ffmq4.common.message.MessageSelector;
import net.timewalker.ffmq4.common.message.MessageTools;
import net.timewalker.ffmq4.common.session.AbstractMessageConsumer;
import net.timewalker.ffmq4.local.FFMQEngine;
import net.timewalker.ffmq4.local.TransactionSet;
import net.timewalker.ffmq4.local.connection.LocalConnection;
import net.timewalker.ffmq4.local.destination.LocalQueue;
import net.timewalker.ffmq4.local.destination.LocalTopic;
import net.timewalker.ffmq4.local.destination.notification.NotificationProxy;
import net.timewalker.ffmq4.local.session.LocalSession;
import net.timewalker.ffmq4.management.destination.definition.QueueDefinition;
import net.timewalker.ffmq4.management.destination.definition.TopicDefinition;
import net.timewalker.ffmq4.utils.ErrorTools;
import net.timewalker.ffmq4.utils.Settings;
import net.timewalker.ffmq4.utils.StringTools;
import net.timewalker.ffmq4.utils.async.AsyncTask;
import net.timewalker.ffmq4.utils.id.IntegerID;
import net.timewalker.ffmq4.utils.id.UUIDProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalMessageConsumer
extends AbstractMessageConsumer {
    private static final Log log = LogFactory.getLog(LocalMessageConsumer.class);
    protected FFMQEngine engine;
    protected MessageSelector parsedSelector;
    private String subscriberId;
    private LocalQueue localQueue;
    private LocalTopic localTopic;
    private boolean traceEnabled;
    private boolean receiving;
    private TransactionSet transactionSet;
    private Object receiveLock = new Object();
    private NotificationProxy notificationProxy;
    private int prefetchSize;
    private int prefetchCapacity;
    private Object prefetchLock = new Object();
    private boolean logListenersFailures;
    private final WakeUpAsyncTask wakeUpAsyncTask = new WakeUpAsyncTask();

    public LocalMessageConsumer(FFMQEngine engine, LocalSession session, Destination destination, String messageSelector, boolean noLocal, IntegerID consumerId, String subscriberId) throws JMSException {
        super(session, destination, messageSelector, noLocal, consumerId);
        this.engine = engine;
        this.session = session;
        this.parsedSelector = StringTools.isNotEmpty(messageSelector) ? new MessageSelector(messageSelector) : null;
        this.traceEnabled = log.isTraceEnabled();
        this.transactionSet = session.getTransactionSet();
        this.notificationProxy = session.getNotificationProxy();
        this.prefetchCapacity = this.prefetchSize = engine.getSetup().getConsumerPrefetchSize();
        this.logListenersFailures = this.getSettings().getBooleanProperty("delivery.logListenersFailures", false);
        this.subscriberId = subscriberId != null ? subscriberId : UUIDProvider.getInstance().getShortUUID();
    }

    @Override
    protected final boolean shouldLogListenersFailures() {
        return this.logListenersFailures;
    }

    public final int getPrefetchSize() {
        return this.prefetchSize;
    }

    protected final Settings getSettings() {
        return this.engine.getSetup().getSettings();
    }

    protected final void initDestination() throws JMSException {
        LocalConnection conn = (LocalConnection)this.session.getConnection();
        if (conn.isSecurityEnabled()) {
            String topicName;
            if (this.destination instanceof Queue) {
                String queueName = ((Queue)this.destination).getQueueName();
                if (!conn.isRegisteredTemporaryQueue(queueName)) {
                    if (queueName.equals("_FFMQ_ADM_REQUEST")) {
                        if (conn.getSecurityContext() != null) {
                            throw new FFMQException("Access denied to administration queue " + queueName, "ACCESS_DENIED");
                        }
                    } else if (queueName.equals("_FFMQ_ADM_REPLY")) {
                        conn.checkPermission("server", "remoteAdmin");
                    } else {
                        conn.checkPermission(this.destination, "consume");
                    }
                }
            } else if (this.destination instanceof Topic && !conn.isRegisteredTemporaryTopic(topicName = ((Topic)this.destination).getTopicName())) {
                conn.checkPermission(this.destination, "consume");
            }
        }
        if (this.destination instanceof Queue) {
            Queue queueRef = (Queue)this.destination;
            this.localQueue = this.engine.getLocalQueue(queueRef.getQueueName());
            this.session.checkTemporaryDestinationScope(this.localQueue);
            this.localQueue.registerConsumer(this);
        } else if (this.destination instanceof Topic) {
            Topic topicRef = (Topic)this.destination;
            this.localTopic = this.engine.getLocalTopic(topicRef.getTopicName());
            this.session.checkTemporaryDestinationScope(this.localTopic);
            TopicDefinition topicDef = this.localTopic.getDefinition();
            QueueDefinition tempDef = topicDef.createQueueDefinition(topicRef.getTopicName(), this.subscriberId, !this.isDurable());
            this.localQueue = this.engine.localQueueExists(tempDef.getName()) ? this.engine.getLocalQueue(tempDef.getName()) : this.engine.createQueue(tempDef);
            this.localQueue.registerConsumer(this);
            this.localTopic.registerConsumer(this);
        } else {
            throw new InvalidDestinationException("Unsupported destination : " + this.destination);
        }
    }

    private void unregister() {
        if (this.localTopic != null) {
            this.localTopic.unregisterConsumer(this);
        }
        if (this.localQueue != null) {
            this.localQueue.unregisterConsumer(this);
            try {
                if (this.destination instanceof Topic && !this.isDurable()) {
                    this.localQueue.close();
                    ((LocalSession)this.session).deleteQueue(this.localQueue.getName());
                }
            }
            catch (JMSException e) {
                ErrorTools.log(e, log);
            }
        }
    }

    @Override
    public final void setMessageListener(MessageListener messageListener) throws JMSException {
        super.setMessageListener(messageListener);
        if (messageListener != null && this.connection.isStarted()) {
            this.engine.getDeliveryAsyncTaskManager().execute(this.wakeUpAsyncTask);
        }
    }

    public boolean isDurable() {
        return false;
    }

    public final MessageSelector getParsedSelector() {
        return this.parsedSelector;
    }

    public final MessageSelector getReceiveSelector() {
        return this.localTopic == null ? this.parsedSelector : null;
    }

    @Override
    protected final void onConsumerClose() {
        super.onConsumerClose();
        this.unregister();
        try {
            this.engine.getDeliveryAsyncTaskManager().cancelTask(this.wakeUpAsyncTask);
        }
        catch (JMSException e) {
            ErrorTools.log(e, log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void onConsumerClosed() {
        Object object = this.receiveLock;
        synchronized (object) {
            this.receiveLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final AbstractMessage receiveFromDestination(long timeout, boolean duplicateRequired) throws JMSException {
        Object object = this.receiveLock;
        synchronized (object) {
            if (this.closed) {
                return null;
            }
            if (this.receiving) {
                throw new FFMQException("Consumer should not be accessed by more than one thread", "ILLEGAL_USAGE");
            }
            this.receiving = true;
            try {
                long now;
                MessageSelector selector = this.getReceiveSelector();
                if (timeout == 0L) {
                    if (!this.connection.isStarted()) {
                        AbstractMessage abstractMessage = null;
                        return abstractMessage;
                    }
                    AbstractMessage message = this.localQueue.get((LocalSession)this.session, this.transactionSet, selector);
                    if (message == null) {
                        AbstractMessage abstractMessage = null;
                        return abstractMessage;
                    }
                    if (this.traceEnabled) {
                        log.trace((Object)(this.session + " [GET] in " + this.localQueue + " - " + message));
                    }
                    if (duplicateRequired) {
                        message = MessageTools.duplicate(message);
                    }
                    message.markAsReadOnly();
                    AbstractMessage abstractMessage = message;
                    return abstractMessage;
                }
                long startTime = now = System.currentTimeMillis();
                while (!(this.closed || timeout >= 0L && now - startTime >= timeout)) {
                    AbstractMessage message;
                    if (this.connection.isStarted() && (message = this.localQueue.get((LocalSession)this.session, this.transactionSet, selector)) != null) {
                        if (this.traceEnabled) {
                            log.trace((Object)(this.session + " [GET] in " + this.localQueue + " - " + message));
                        }
                        if (duplicateRequired) {
                            message = MessageTools.duplicate(message);
                        }
                        message.markAsReadOnly();
                        AbstractMessage abstractMessage = message;
                        return abstractMessage;
                    }
                    if (this.traceEnabled) {
                        log.trace((Object)("Entering passive wait on " + this.localQueue + " (timeout=" + timeout + ")"));
                    }
                    try {
                        if (timeout <= 0L) {
                            this.receiveLock.wait();
                        } else {
                            this.receiveLock.wait(timeout - (now - startTime));
                        }
                    }
                    catch (InterruptedException e) {
                        AbstractMessage abstractMessage = null;
                        this.receiving = false;
                        return abstractMessage;
                    }
                    now = System.currentTimeMillis();
                }
                AbstractMessage abstractMessage = null;
                return abstractMessage;
            }
            finally {
                this.receiving = false;
            }
        }
    }

    @Override
    public final void wakeUp() throws JMSException {
        if (this.closed) {
            return;
        }
        if (!this.connection.isStarted()) {
            return;
        }
        this.propagateNotification();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void prefetchMore() throws JMSException {
        Object object = this.prefetchLock;
        synchronized (object) {
            this.prefetchCapacity = this.prefetchSize;
        }
        this.wakeUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void restorePrefetchCapacity(int amount) throws JMSException {
        Object object = this.prefetchLock;
        synchronized (object) {
            this.prefetchCapacity += amount;
        }
        this.wakeUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propagateNotification() throws JMSException {
        if (this.notificationProxy != null) {
            int count = 0;
            Object object = this.prefetchLock;
            synchronized (object) {
                AbstractMessage message;
                if (this.prefetchCapacity < this.prefetchSize) {
                    return;
                }
                while (this.prefetchCapacity > 0 && (message = this.receiveFromDestination(0L, false)) != null) {
                    ++count;
                    --this.prefetchCapacity;
                    this.notificationProxy.addNotification(this.id, message);
                }
            }
            if (count > 0) {
                this.notificationProxy.flush();
            }
        } else if (this.messageListener != null) {
            this.engine.getDeliveryAsyncTaskManager().execute(this.wakeUpAsyncTask);
        } else {
            Object object = this.receiveLock;
            synchronized (object) {
                if (this.receiving) {
                    this.receiveLock.notify();
                }
            }
        }
    }

    public final boolean getNoLocal() {
        return this.noLocal;
    }

    public final LocalQueue getLocalQueue() {
        return this.localQueue;
    }

    public final String getSubscriberId() {
        return this.subscriberId;
    }

    private final class WakeUpAsyncTask
    implements AsyncTask {
        @Override
        public final boolean isMergeable() {
            return true;
        }

        @Override
        public final void execute() {
            LocalMessageConsumer.this.wakeUpMessageListener();
        }
    }
}

