/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.local.connection;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.common.connection.AbstractConnection;
import net.timewalker.ffmq4.common.destination.DestinationRef;
import net.timewalker.ffmq4.common.destination.DestinationTools;
import net.timewalker.ffmq4.local.FFMQEngine;
import net.timewalker.ffmq4.local.connection.ClientIDRegistry;
import net.timewalker.ffmq4.local.session.LocalSession;
import net.timewalker.ffmq4.security.SecurityContext;
import net.timewalker.ffmq4.utils.id.IntegerID;

public class LocalConnection
extends AbstractConnection {
    protected FFMQEngine engine;
    private SecurityContext securityContext;

    public LocalConnection(FFMQEngine engine, SecurityContext securityContext, String clientID) {
        super(clientID);
        this.engine = engine;
        this.securityContext = securityContext;
    }

    @Override
    public final void setClientID(String clientID) throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            super.setClientID(clientID);
            try {
                ClientIDRegistry.getInstance().register(clientID);
            }
            catch (JMSException e) {
                this.clientID = null;
                throw e;
            }
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    public final Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return this.createSession(this.idProvider.createID(), transacted, acknowledgeMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Session createSession(IntegerID sessionId, boolean transacted, int acknowledgeMode) throws JMSException {
        if (!transacted && acknowledgeMode == 0) {
            throw new FFMQException("Acknowledge mode SESSION_TRANSACTED cannot be used for an non-transacted session", "INVALID_ACK_MODE");
        }
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            LocalSession session = new LocalSession(sessionId, this, this.engine, transacted, acknowledgeMode);
            this.registerSession(session);
            LocalSession localSession = session;
            return localSession;
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    public final void start() throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            if (this.started) {
                return;
            }
            this.started = true;
            this.wakeUpLocalConsumers();
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    public final void stop() throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            this.checkNotClosed();
            if (!this.started) {
                return;
            }
            this.started = false;
            this.waitForDeliverySync();
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    @Override
    public final void deleteTemporaryQueue(String queueName) throws JMSException {
        this.engine.deleteQueue(queueName);
        this.unregisterTemporaryQueue(queueName);
    }

    @Override
    public final void deleteTemporaryTopic(String topicName) throws JMSException {
        this.engine.deleteTopic(topicName);
        this.unregisterTemporaryTopic(topicName);
    }

    public final void checkPermission(Destination destination, String action) throws JMSException {
        if (this.securityContext == null) {
            return;
        }
        DestinationRef destinationRef = DestinationTools.asRef(destination);
        this.securityContext.checkPermission(destinationRef.getResourceName(), action);
    }

    public final boolean isSecurityEnabled() {
        return this.securityContext != null;
    }

    public final void checkPermission(String resource, String action) throws JMSException {
        if (this.securityContext == null) {
            return;
        }
        this.securityContext.checkPermission(resource, action);
    }

    public final SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    protected void onConnectionClose() {
        super.onConnectionClose();
        if (this.clientID != null) {
            ClientIDRegistry.getInstance().unregister(this.clientID);
        }
    }
}

