/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.session;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.common.message.MessageTools;
import net.timewalker.ffmq4.common.session.AbstractMessageHandler;
import net.timewalker.ffmq4.common.session.AbstractSession;
import net.timewalker.ffmq4.utils.id.IntegerID;
import net.timewalker.ffmq4.utils.id.UUIDProvider;

public abstract class AbstractMessageProducer
extends AbstractMessageHandler
implements MessageProducer {
    protected int defaultDeliveryMode = 2;
    protected int defaultPriority = 4;
    protected long defaultTimeToLive = 0L;
    protected boolean disableMessageID;
    protected boolean disableMessageTimestamp;
    protected UUIDProvider uuidProvider = UUIDProvider.getInstance();

    public AbstractMessageProducer(AbstractSession session, Destination destination, IntegerID producerId) {
        super(session, destination, producerId);
    }

    public final void close() throws JMSException {
        this.externalAccessLock.readLock().lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.onProducerClose();
        }
        finally {
            this.externalAccessLock.readLock().unlock();
        }
    }

    protected final void onProducerClose() {
        this.session.unregisterProducer(this);
    }

    public final int getDeliveryMode() {
        return this.defaultDeliveryMode;
    }

    public final Destination getDestination() {
        return this.destination;
    }

    public final boolean getDisableMessageID() {
        return this.disableMessageID;
    }

    public final boolean getDisableMessageTimestamp() {
        return this.disableMessageTimestamp;
    }

    public final int getPriority() {
        return this.defaultPriority;
    }

    public final long getTimeToLive() {
        return this.defaultTimeToLive;
    }

    public final void setDeliveryMode(int deliveryMode) throws JMSException {
        if (deliveryMode != 2 && deliveryMode != 1) {
            throw new FFMQException("Invalid delivery mode : " + deliveryMode, "INVALID_DELIVERY_MODE");
        }
        this.defaultDeliveryMode = deliveryMode;
    }

    public final void setDisableMessageID(boolean disableMessageID) {
        this.disableMessageID = disableMessageID;
    }

    public final void setDisableMessageTimestamp(boolean disableMessageTimestamp) {
        this.disableMessageTimestamp = disableMessageTimestamp;
    }

    public final void setPriority(int priority) throws JMSException {
        if (priority < 0 || priority > 9) {
            throw new FFMQException("Invalid priority value : " + priority, "INVALID_PRIORITY");
        }
        this.defaultPriority = priority;
    }

    public final void setTimeToLive(long timeToLive) {
        this.defaultTimeToLive = timeToLive;
    }

    public final void send(Message message) throws JMSException {
        if (this.destination == null) {
            throw new UnsupportedOperationException("Destination was not set at creation time");
        }
        this.setupMessage(this.destination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive);
        message = MessageTools.normalize(message);
        this.sendToDestination(this.destination, false, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive);
    }

    public final void send(Destination destination, Message message) throws JMSException {
        if (this.destination != null) {
            throw new UnsupportedOperationException("Destination was set at creation time");
        }
        this.setupMessage(destination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive);
        message = MessageTools.normalize(message);
        this.sendToDestination(destination, true, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive);
    }

    public final void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (this.destination == null) {
            throw new UnsupportedOperationException("Destination was not set at creation time");
        }
        this.setupMessage(this.destination, message, deliveryMode, priority, timeToLive);
        message = MessageTools.normalize(message);
        this.sendToDestination(this.destination, false, message, deliveryMode, priority, timeToLive);
    }

    public final void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (this.destination != null) {
            throw new UnsupportedOperationException("Destination was set at creation time");
        }
        this.setupMessage(destination, message, deliveryMode, priority, timeToLive);
        message = MessageTools.normalize(message);
        this.sendToDestination(destination, true, message, deliveryMode, priority, timeToLive);
    }

    protected final void setupMessage(Destination destinationRef, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        long now = System.currentTimeMillis();
        message.setJMSMessageID(this.uuidProvider.getUUID());
        message.setJMSTimestamp(this.disableMessageTimestamp ? 0L : now);
        message.setJMSDeliveryMode(deliveryMode);
        message.setJMSPriority(priority);
        message.setJMSExpiration(timeToLive > 0L ? timeToLive + now : 0L);
        message.setJMSDestination(destinationRef);
    }

    protected abstract void sendToDestination(Destination var1, boolean var2, Message var3, int var4, int var5, long var6) throws JMSException;
}

