/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.message.selector.expression.operator;

import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import net.timewalker.ffmq4.common.message.selector.expression.SelectorNode;
import net.timewalker.ffmq4.common.message.selector.expression.operator.AbstractArithmeticBinaryOperator;
import net.timewalker.ffmq4.common.message.selector.expression.utils.ArithmeticUtils;

public class SumOperator
extends AbstractArithmeticBinaryOperator {
    public SumOperator(SelectorNode leftOperand, SelectorNode rightOperand) throws InvalidSelectorException {
        super(leftOperand, rightOperand);
    }

    @Override
    public Object evaluate(Message message) throws JMSException {
        Number leftValue = this.leftOperand.evaluateNumeric(message);
        Number rightValue = this.rightOperand.evaluateNumeric(message);
        if (leftValue == null || rightValue == null) {
            return null;
        }
        return ArithmeticUtils.sum(leftValue, rightValue);
    }

    public String toString() {
        return this.parenthesize(this.leftOperand) + " + " + this.parenthesize(this.rightOperand);
    }
}

