/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.message.selector;

import java.util.ArrayList;
import java.util.List;
import javax.jms.InvalidSelectorException;

public final class MessageSelectorTokenizer {
    private static final String[] SYMBOL_DELIMITERS = new String[]{"=", "<>", "<=", ">=", "<", ">", "+", "-", "/", "*", "(", ")", ","};
    private List<String> tokens = new ArrayList<String>();
    private int tokenizerOffset;

    public MessageSelectorTokenizer(String messageSelector) throws InvalidSelectorException {
        this.tokenize(messageSelector);
    }

    private String getSymbolDelimiter(String text, int offset) {
        for (int n = 0; n < SYMBOL_DELIMITERS.length; ++n) {
            if (!text.startsWith(SYMBOL_DELIMITERS[n], offset)) continue;
            return SYMBOL_DELIMITERS[n];
        }
        return null;
    }

    private void tokenize(String text) throws InvalidSelectorException {
        boolean inQuotes = false;
        int textLen = text.length();
        int pos = 0;
        StringBuilder buf = new StringBuilder();
        while (pos < textLen) {
            char c = text.charAt(pos);
            if (inQuotes) {
                if (c == '\'') {
                    buf.append('\'');
                    if (pos < textLen - 1 && text.charAt(pos + 1) == '\'') {
                        buf.append('\'');
                        ++pos;
                    } else {
                        inQuotes = false;
                        this.addAndCompress(buf.toString(), this.tokens);
                        buf.setLength(0);
                    }
                } else {
                    buf.append(c);
                }
                ++pos;
                continue;
            }
            if (c == '\'') {
                buf.append('\'');
                inQuotes = true;
                ++pos;
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (buf.length() > 0) {
                    this.addAndCompress(buf.toString(), this.tokens);
                    buf.setLength(0);
                }
                ++pos;
                continue;
            }
            String delimiter = this.getSymbolDelimiter(text, pos);
            if (delimiter != null) {
                if (buf.length() > 0) {
                    this.addAndCompress(buf.toString(), this.tokens);
                    buf.setLength(0);
                }
                this.addAndCompress(delimiter, this.tokens);
                pos += delimiter.length();
                continue;
            }
            buf.append(c);
            ++pos;
        }
        if (inQuotes) {
            throw new InvalidSelectorException("Expression contains an unclosed quote");
        }
        if (buf.length() > 0) {
            this.addAndCompress(buf.toString(), this.tokens);
            buf.setLength(0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addAndCompress(String token, List<String> tokensList) throws InvalidSelectorException {
        if (tokensList.isEmpty()) {
            tokensList.add(token);
            return;
        }
        String previous = tokensList.get(tokensList.size() - 1);
        if (previous.equalsIgnoreCase("is")) {
            if (!token.equalsIgnoreCase("true") && !token.equalsIgnoreCase("false") && !token.equalsIgnoreCase("null") && !token.equalsIgnoreCase("not")) throw new InvalidSelectorException("Unexpected token after 'is' operator : " + token);
            tokensList.set(tokensList.size() - 1, "is " + token);
            return;
        } else if (previous.equalsIgnoreCase("is not")) {
            if (!token.equalsIgnoreCase("true") && !token.equalsIgnoreCase("false") && !token.equalsIgnoreCase("null")) throw new InvalidSelectorException("Unexpected token after 'is not' operator : " + token);
            tokensList.set(tokensList.size() - 1, "is not " + token);
            return;
        } else if (previous.equalsIgnoreCase("not")) {
            if (token.equalsIgnoreCase("in") || token.equalsIgnoreCase("between") || token.equalsIgnoreCase("like") || token.equalsIgnoreCase("true") || token.equalsIgnoreCase("false")) {
                tokensList.set(tokensList.size() - 1, "not " + token);
                return;
            } else {
                tokensList.add(token);
            }
            return;
        } else {
            tokensList.add(token);
        }
    }

    public boolean hasMoreTokens() {
        return this.tokenizerOffset < this.tokens.size();
    }

    public String nextToken() {
        if (this.hasMoreTokens()) {
            return this.tokens.get(this.tokenizerOffset++);
        }
        return null;
    }
}

