/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.message;

import net.timewalker.ffmq4.common.message.AbstractMessage;
import net.timewalker.ffmq4.common.message.MessageType;
import net.timewalker.ffmq4.utils.RawDataBuffer;

public final class MessageSerializer {
    public static byte[] serialize(AbstractMessage message, int typicalSize) {
        RawDataBuffer rawMsg = message.getRawMessage();
        if (rawMsg != null) {
            return rawMsg.toByteArray();
        }
        RawDataBuffer buffer = new RawDataBuffer(typicalSize);
        buffer.writeByte(message.getType());
        message.serializeTo(buffer);
        return buffer.toByteArray();
    }

    public static AbstractMessage unserialize(byte[] rawData, boolean asInternalCopy) {
        RawDataBuffer rawIn = new RawDataBuffer(rawData);
        byte type = rawIn.readByte();
        AbstractMessage message = MessageType.createInstance(type);
        message.initializeFromRaw(rawIn);
        if (asInternalCopy) {
            message.setInternalCopy(true);
        }
        return message;
    }

    public static void serializeTo(AbstractMessage message, RawDataBuffer out) {
        RawDataBuffer rawMsg = message.getRawMessage();
        if (rawMsg != null) {
            out.writeInt(rawMsg.size());
            rawMsg.writeTo(out);
        } else {
            out.writeInt(0);
            int startPos = out.size();
            out.writeByte(message.getType());
            message.serializeTo(out);
            int endPos = out.size();
            out.writeInt(endPos - startPos, startPos - 4);
        }
    }

    public static AbstractMessage unserializeFrom(RawDataBuffer rawIn, boolean asInternalCopy) {
        int size = rawIn.readInt();
        RawDataBuffer rawMessage = new RawDataBuffer(rawIn.readBytes(size));
        byte type = rawMessage.readByte();
        AbstractMessage message = MessageType.createInstance(type);
        message.initializeFromRaw(rawMessage);
        if (asInternalCopy) {
            message.setInternalCopy(true);
        }
        return message;
    }
}

