/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.message;

import javax.jms.MessageFormatException;
import net.timewalker.ffmq4.utils.ArrayTools;

public final class MessageConvertTools {
    public static boolean asBoolean(Object value) throws MessageFormatException {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        throw new MessageFormatException("Could not convert type to boolean : (" + value.getClass().getName() + ") " + value);
    }

    public static byte asByte(Object value) throws MessageFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            return Byte.valueOf((String)value);
        }
        throw new MessageFormatException("Could not convert type to byte : (" + value.getClass().getName() + ") " + value);
    }

    public static byte[] asBytes(Object value) throws MessageFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return ArrayTools.copy((byte[])value);
        }
        throw new MessageFormatException("Could not convert type to byte[] : (" + value.getClass().getName() + ") " + value);
    }

    public static short asShort(Object value) throws MessageFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        if (value instanceof String) {
            return Short.valueOf((String)value);
        }
        throw new MessageFormatException("Could not convert type to short : (" + value.getClass().getName() + ") " + value);
    }

    public static int asInt(Object value) throws MessageFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        throw new MessageFormatException("Could not convert type to int : (" + value.getClass().getName() + ") " + value);
    }

    public static long asLong(Object value) throws MessageFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        if (value instanceof Short) {
            return ((Short)value).shortValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        throw new MessageFormatException("Could not convert type to long : (" + value.getClass().getName() + ") " + value);
    }

    public static float asFloat(Object value) throws MessageFormatException {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String) {
            return Float.valueOf((String)value).floatValue();
        }
        throw new MessageFormatException("Could not convert type to float : (" + value.getClass().getName() + ") " + value);
    }

    public static double asDouble(Object value) throws MessageFormatException {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String) {
            return Double.valueOf((String)value);
        }
        throw new MessageFormatException("Could not convert type to double : (" + value.getClass().getName() + ") " + value);
    }

    public static char asChar(Object value) throws MessageFormatException {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        throw new MessageFormatException("Could not convert type to char : (" + value.getClass().getName() + ") " + value);
    }

    public static String asString(Object value) throws MessageFormatException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Boolean || value instanceof Byte || value instanceof Character || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Character) {
            return String.valueOf(value);
        }
        throw new MessageFormatException("Could not convert type to String : (" + value.getClass().getName() + ") " + value);
    }
}

