/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.destination;

import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.common.destination.DestinationRef;
import net.timewalker.ffmq4.common.destination.QueueRef;
import net.timewalker.ffmq4.common.destination.TopicRef;

public final class DestinationTools {
    public static DestinationRef asRef(Destination destination) throws JMSException {
        if (destination == null) {
            return null;
        }
        if (destination instanceof DestinationRef) {
            return (DestinationRef)destination;
        }
        if (destination instanceof Queue) {
            return new QueueRef(((Queue)destination).getQueueName());
        }
        if (destination instanceof Topic) {
            return new TopicRef(((Topic)destination).getTopicName());
        }
        throw new InvalidDestinationException("Unsupported destination type : " + destination, "INVALID_DESTINATION");
    }

    public static Queue asRef(Queue queue) throws JMSException {
        if (queue == null) {
            return null;
        }
        if (queue instanceof QueueRef) {
            return queue;
        }
        return new QueueRef(queue.getQueueName());
    }

    public static Topic asRef(Topic topic) throws JMSException {
        if (topic == null) {
            return null;
        }
        if (topic instanceof TopicRef) {
            return topic;
        }
        return new TopicRef(topic.getTopicName());
    }

    public static String getQueueNameForTopicConsumer(String topicName, String consumerID) {
        return topicName + "-" + consumerID;
    }

    private static void checkDestinationName(String destinationName) throws JMSException {
        for (int i = 0; i < destinationName.length(); ++i) {
            char c = destinationName.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '-') continue;
            throw new FFMQException("Destination name '" + destinationName + "' contains an invalid character : " + c, "INVALID_DESTINATION_NAME");
        }
    }

    public static void checkQueueName(String queueName) throws JMSException {
        if (queueName == null) {
            throw new FFMQException("Queue name is not set", "INVALID_DESTINATION_NAME");
        }
        if (queueName.length() > 128) {
            throw new FFMQException("Queue name '" + queueName + "' is too long (" + queueName.length() + " > " + 128 + ")", "INVALID_DESTINATION_NAME");
        }
        DestinationTools.checkDestinationName(queueName);
    }

    public static void checkTopicName(String topicName) throws JMSException {
        if (topicName == null) {
            throw new FFMQException("Topic name is not set", "INVALID_DESTINATION_NAME");
        }
        if (topicName.length() > 196) {
            throw new FFMQException("Topic name '" + topicName + "' is too long (" + topicName.length() + " > " + 196 + ")", "INVALID_DESTINATION_NAME");
        }
        DestinationTools.checkDestinationName(topicName);
    }
}

