/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FFMQVersion {
    private static final Log log = LogFactory.getLog(FFMQVersion.class);
    private static int PROVIDER_MAJOR_VERSION = 0;
    private static int PROVIDER_MINOR_VERSION = 0;
    private static String PROVIDER_RELEASE_VERSION = "devel";
    private static final int JMS_MAJOR_VERSION = 1;
    private static final int JMS_MINOR_VERSION = 1;

    public static int getProviderMajorVersion() {
        return PROVIDER_MAJOR_VERSION;
    }

    public static int getProviderMinorVersion() {
        return PROVIDER_MINOR_VERSION;
    }

    public static String getProviderReleaseVersion() {
        return PROVIDER_RELEASE_VERSION;
    }

    public static int getJMSMajorVersion() {
        return 1;
    }

    public static int getJMSMinorVersion() {
        return 1;
    }

    static {
        try {
            InputStream in = FFMQVersion.class.getClassLoader().getResourceAsStream("net/timewalker/ffmq4/FFMQ.version");
            if (in != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                String versionString = reader.readLine();
                reader.close();
                if (versionString != null && !versionString.startsWith("$")) {
                    StringTokenizer st = new StringTokenizer(versionString, ".");
                    int majorVersion = Integer.parseInt(st.nextToken());
                    int minorVersion = Integer.parseInt(st.nextToken());
                    String releaseVersion = st.nextToken();
                    PROVIDER_MAJOR_VERSION = majorVersion;
                    PROVIDER_MINOR_VERSION = minorVersion;
                    PROVIDER_RELEASE_VERSION = releaseVersion;
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)("Could not retrieve FFMQ version information : " + e.toString()));
        }
    }
}

