/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.jbehave.runners;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import de.codecentric.jbehave.junit.monitoring.JUnitDescriptionGenerator;
import de.codecentric.jbehave.junit.monitoring.JUnitScenarioReporter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.jbehave.ThucydidesJBehaveSystemProperties;
import net.thucydides.jbehave.ThucydidesJUnitStories;
import org.codehaus.plexus.util.StringUtils;
import org.jbehave.core.ConfigurableEmbedder;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.embedder.Embedder;
import org.jbehave.core.embedder.StoryRunner;
import org.jbehave.core.io.StoryPathResolver;
import org.jbehave.core.junit.JUnitStories;
import org.jbehave.core.junit.JUnitStory;
import org.jbehave.core.model.Story;
import org.jbehave.core.reporters.Format;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.NullStepMonitor;
import org.jbehave.core.steps.StepMonitor;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;

public class ThucydidesReportingRunner
extends Runner {
    private List<Description> storyDescriptions;
    private Embedder configuredEmbedder;
    private List<String> storyPaths;
    private Configuration configuration;
    private Description description;
    List<CandidateSteps> candidateSteps;
    private final ConfigurableEmbedder configurableEmbedder;
    private final Class<? extends ConfigurableEmbedder> testClass;
    private final EnvironmentVariables environmentVariables;
    private final String SKIP_FILTER = "-skip";
    private final String IGNORE_FILTER = "-ignore";
    private final String DEFAULT_METAFILTER = "-skip -ignore";
    private int testCount = 0;

    public ThucydidesReportingRunner(Class<? extends ConfigurableEmbedder> testClass) throws Throwable {
        this(testClass, testClass.newInstance());
    }

    public ThucydidesReportingRunner(Class<? extends ConfigurableEmbedder> testClass, ConfigurableEmbedder embedder) throws Throwable {
        this.configurableEmbedder = embedder;
        this.testClass = testClass;
        this.environmentVariables = this.environmentVariablesFrom(this.configurableEmbedder);
    }

    protected List<Description> getDescriptions() {
        if (this.storyDescriptions == null) {
            this.storyDescriptions = this.buildDescriptionFromStories();
        }
        return this.storyDescriptions;
    }

    protected Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = this.getConfiguredEmbedder().configuration();
        }
        return this.configuration;
    }

    Embedder getConfiguredEmbedder() {
        if (this.configuredEmbedder == null) {
            this.configuredEmbedder = this.configurableEmbedder.configuredEmbedder();
        }
        return this.configuredEmbedder;
    }

    List<String> getStoryPaths() {
        if (this.storyPaths == null || this.storyPaths.isEmpty()) {
            try {
                if (this.configurableEmbedder instanceof JUnitStory) {
                    this.getStoryPathsFromJUnitStory();
                } else if (this.configurableEmbedder instanceof JUnitStories) {
                    this.getStoryPathsFromJUnitStories(this.testClass);
                }
            }
            catch (Throwable e) {
                return Collections.EMPTY_LIST;
            }
        }
        return this.storyPaths;
    }

    private EnvironmentVariables environmentVariablesFrom(ConfigurableEmbedder configurableEmbedder) {
        if (configurableEmbedder instanceof ThucydidesJUnitStories) {
            return ((ThucydidesJUnitStories)configurableEmbedder).getEnvironmentVariables();
        }
        return (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
    }

    public Description getDescription() {
        if (this.description == null) {
            this.description = Description.createSuiteDescription(this.configurableEmbedder.getClass());
            this.description.getChildren().addAll(this.getDescriptions());
        }
        return this.description;
    }

    public int testCount() {
        if (this.testCount == 0) {
            this.testCount = this.countStories();
        }
        return this.testCount;
    }

    public void run(RunNotifier notifier) {
        this.getConfiguredEmbedder().embedderControls().doIgnoreFailureInView(true);
        this.getConfiguredEmbedder().embedderControls().doIgnoreFailureInStories(this.getIgnoreFailuresInStories());
        this.getConfiguredEmbedder().embedderControls().useStoryTimeoutInSecs((long)this.getStoryTimeoutInSecs());
        if (this.metaFiltersAreDefined()) {
            this.getConfiguredEmbedder().useMetaFilters(this.getMetaFilters());
        }
        JUnitScenarioReporter junitReporter = new JUnitScenarioReporter(notifier, this.testCount(), this.getDescription(), new Keywords());
        junitReporter.usePendingStepStrategy(this.getConfiguration().pendingStepStrategy());
        this.addToStoryReporterFormats(junitReporter);
        try {
            this.getConfiguredEmbedder().runStoriesAsPaths(this.getStoryPaths());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.usingUniqueBrowser()) {
                ThucydidesWebDriverSupport.closeAllDrivers();
            }
            this.getConfiguredEmbedder().generateCrossReference();
        }
    }

    List<CandidateSteps> getCandidateSteps() {
        if (this.candidateSteps == null) {
            StepMonitor originalStepMonitor = this.createCandidateStepsWithNoMonitor();
            this.createCandidateStepsWith(originalStepMonitor);
        }
        return this.candidateSteps;
    }

    private void createCandidateStepsWith(StepMonitor stepMonitor) {
        this.getConfiguration().useStepMonitor(stepMonitor);
        this.candidateSteps = this.buildCandidateSteps();
        for (CandidateSteps step : this.candidateSteps) {
            step.configuration().useStepMonitor(stepMonitor);
        }
    }

    private StepMonitor createCandidateStepsWithNoMonitor() {
        StepMonitor usedStepMonitor = this.getConfiguration().stepMonitor();
        this.createCandidateStepsWith((StepMonitor)new NullStepMonitor());
        return usedStepMonitor;
    }

    private void getStoryPathsFromJUnitStory() {
        StoryPathResolver resolver = this.getConfiguredEmbedder().configuration().storyPathResolver();
        this.storyPaths = Arrays.asList(resolver.resolve(this.configurableEmbedder.getClass()));
    }

    private void getStoryPathsFromJUnitStories(Class<? extends ConfigurableEmbedder> testClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = this.makeStoryPathsMethodPublic(testClass);
        this.storyPaths = (List)method.invoke((Object)this.configurableEmbedder, (Object[])null);
    }

    private Method makeStoryPathsMethodPublic(Class<? extends ConfigurableEmbedder> testClass) throws NoSuchMethodException {
        Method method;
        try {
            method = testClass.getDeclaredMethod("storyPaths", null);
        }
        catch (NoSuchMethodException e) {
            method = testClass.getMethod("storyPaths", null);
        }
        method.setAccessible(true);
        return method;
    }

    private List<CandidateSteps> buildCandidateSteps() {
        List candidateSteps;
        InjectableStepsFactory stepsFactory = this.configurableEmbedder.stepsFactory();
        if (stepsFactory != null) {
            candidateSteps = stepsFactory.createCandidateSteps();
        } else {
            Embedder embedder = this.configurableEmbedder.configuredEmbedder();
            candidateSteps = embedder.candidateSteps();
            if (candidateSteps == null || candidateSteps.isEmpty()) {
                candidateSteps = embedder.stepsFactory().createCandidateSteps();
            }
        }
        return candidateSteps;
    }

    private void addToStoryReporterFormats(JUnitScenarioReporter junitReporter) {
        StoryReporterBuilder storyReporterBuilder = this.getConfiguration().storyReporterBuilder();
        StoryReporterBuilder.ProvidedFormat junitReportFormat = new StoryReporterBuilder.ProvidedFormat((StoryReporter)junitReporter);
        storyReporterBuilder.withFormats(new Format[]{junitReportFormat});
    }

    private List<Description> buildDescriptionFromStories() {
        JUnitDescriptionGenerator descriptionGenerator = new JUnitDescriptionGenerator(this.getCandidateSteps(), this.getConfiguration());
        StoryRunner storyRunner = new StoryRunner();
        ArrayList<Description> storyDescriptions = new ArrayList<Description>();
        this.addSuite(storyDescriptions, "BeforeStories");
        this.addStories(storyDescriptions, storyRunner, descriptionGenerator);
        this.addSuite(storyDescriptions, "AfterStories");
        return storyDescriptions;
    }

    private int countStories() {
        JUnitDescriptionGenerator descriptionGenerator = new JUnitDescriptionGenerator(this.getCandidateSteps(), this.getConfiguration());
        return descriptionGenerator.getTestCases() + this.beforeAndAfterStorySteps();
    }

    private int beforeAndAfterStorySteps() {
        return 2;
    }

    private void addStories(List<Description> storyDescriptions, StoryRunner storyRunner, JUnitDescriptionGenerator gen) {
        for (String storyPath : this.getStoryPaths()) {
            Story parseStory = storyRunner.storyOfPath(this.getConfiguration(), storyPath);
            Description descr = gen.createDescriptionFrom(parseStory);
            storyDescriptions.add(descr);
        }
    }

    private void addSuite(List<Description> storyDescriptions, String name) {
        storyDescriptions.add(Description.createTestDescription(Object.class, (String)name));
    }

    private boolean metaFiltersAreDefined() {
        String metaFilters = this.getMetafilterSetting();
        return !StringUtils.isEmpty((String)metaFilters);
    }

    private String getMetafilterSetting() {
        String metaFilters = this.environmentVariables.getProperty(ThucydidesJBehaveSystemProperties.METAFILTER.getName(), "-skip -ignore");
        if (!metaFilters.contains("-skip")) {
            metaFilters = metaFilters + "-skip";
        }
        if (!metaFilters.contains("-ignore")) {
            metaFilters = metaFilters + "-ignore";
        }
        return metaFilters;
    }

    protected boolean getIgnoreFailuresInStories() {
        return this.environmentVariables.getPropertyAsBoolean(ThucydidesJBehaveSystemProperties.IGNORE_FAILURES_IN_STORIES.getName(), true);
    }

    protected int getStoryTimeoutInSecs() {
        return this.environmentVariables.getPropertyAsInteger(ThucydidesJBehaveSystemProperties.STORY_TIMEOUT_IN_SECS.getName(), Integer.valueOf(300));
    }

    protected List<String> getMetaFilters() {
        String metaFilters = this.getMetafilterSetting();
        return Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)metaFilters));
    }

    public boolean usingUniqueBrowser() {
        return this.environmentVariables.getPropertyAsBoolean((Enum)ThucydidesSystemProperty.UNIQUE_BROWSER, false);
    }
}

