/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.plugins.jira.requirements;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.plugins.jira.client.JerseyJiraClient;
import net.thucydides.plugins.jira.domain.CustomFieldCast;
import net.thucydides.plugins.jira.domain.IssueSummary;
import net.thucydides.plugins.jira.requirements.ConfigurableJiraClient;
import net.thucydides.plugins.jira.requirements.IssueTagReader;
import net.thucydides.plugins.jira.requirements.JIRARequirementsConfiguration;
import net.thucydides.plugins.jira.service.JIRAConfiguration;
import net.thucydides.plugins.jira.service.SystemPropertiesJIRAConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JIRARequirementsProvider
implements RequirementsTagProvider {
    private List<Requirement> requirements = null;
    private final JerseyJiraClient jiraClient;
    private final String projectKey;
    private final EnvironmentVariables environmentVariables;
    private final String EPIC_LINK = "Epic Link";
    private final Logger logger = LoggerFactory.getLogger(JIRARequirementsProvider.class);
    private final ListeningExecutorService executorService;
    private final AtomicInteger queueSize = new AtomicInteger(0);
    static int DEFAULT_MAX_THREADS = 4;
    private final List<Requirement> NO_REQUIREMENTS = ImmutableList.of();

    public JIRARequirementsProvider() {
        this((JIRAConfiguration)new SystemPropertiesJIRAConfiguration((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get()), (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    public JIRARequirementsProvider(JIRAConfiguration jiraConfiguration) {
        this(jiraConfiguration, (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    private int getMaxJobs() {
        return this.environmentVariables.getPropertyAsInteger(JIRARequirementsConfiguration.JIRA_MAX_THREADS.getName(), Integer.valueOf(DEFAULT_MAX_THREADS));
    }

    public JIRARequirementsProvider(JIRAConfiguration jiraConfiguration, EnvironmentVariables environmentVariables) {
        this.logConnectionDetailsFor(jiraConfiguration);
        this.projectKey = jiraConfiguration.getProject();
        this.environmentVariables = environmentVariables;
        this.jiraClient = new ConfigurableJiraClient(jiraConfiguration.getJiraUrl(), jiraConfiguration.getJiraUser(), jiraConfiguration.getJiraPassword(), this.projectKey).usingCustomFields(this.customFieldsDefinedIn(environmentVariables));
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(this.getMaxJobs()));
    }

    private List<String> definedCustomFields() {
        ArrayList customFields = Lists.newArrayList();
        int customFieldIndex = 1;
        while (this.addCustomFieldIfDefined(this.environmentVariables, customFields, this.customFieldNumber(customFieldIndex++))) {
        }
        return customFields;
    }

    private List<String> customFieldsDefinedIn(EnvironmentVariables environmentVariables) {
        ArrayList customFields = Lists.newArrayList();
        this.addCustomFieldIfDefined(environmentVariables, customFields, JIRARequirementsConfiguration.JIRA_CUSTOM_NARRATIVE_FIELD.getName());
        customFields.addAll(this.definedCustomFields());
        return customFields;
    }

    private String customFieldNumber(int customFieldIndex) {
        return String.valueOf(JIRARequirementsConfiguration.JIRA_CUSTOM_FIELD.getName()) + "." + customFieldIndex;
    }

    private boolean addCustomFieldIfDefined(EnvironmentVariables environmentVariables, List<String> customFields, String customField) {
        String customFieldName = environmentVariables.getProperty(customField);
        if (StringUtils.isNotEmpty((CharSequence)customFieldName)) {
            customFields.add(customFieldName);
            return true;
        }
        return false;
    }

    private void logConnectionDetailsFor(JIRAConfiguration jiraConfiguration) {
        this.logger.debug("JIRA URL: {0}", (Object)jiraConfiguration.getJiraUrl());
        this.logger.debug("JIRA project: {0}", (Object)jiraConfiguration.getProject());
        this.logger.debug("JIRA user: {0}", (Object)jiraConfiguration.getJiraUser());
    }

    private String getProjectKey() {
        return this.projectKey;
    }

    public List<Requirement> getRequirements() {
        this.requirements = this.persisted(this.requirements);
        if (this.requirements == null && this.providerActivated()) {
            List rootRequirementIssues;
            this.logger.info("Loading root requirements: " + this.rootRequirementsJQL());
            try {
                rootRequirementIssues = this.jiraClient.findByJQL(this.rootRequirementsJQL());
            }
            catch (JSONException e) {
                this.logger.info("No root requirements found (JQL = " + this.rootRequirementsJQL(), (Throwable)e);
                rootRequirementIssues = Lists.newArrayList();
            }
            this.logger.debug("Loading root requirements done: " + rootRequirementIssues.size());
            this.requirements = Collections.synchronizedList(new ArrayList());
            for (final IssueSummary issueSummary : rootRequirementIssues) {
                final ListenableFuture future = this.executorService.submit((Callable)new Callable<IssueSummary>(){

                    @Override
                    public IssueSummary call() throws Exception {
                        return issueSummary;
                    }
                });
                future.addListener(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JIRARequirementsProvider.this.queueSize.incrementAndGet();
                            Requirement requirement = JIRARequirementsProvider.this.requirementFrom((IssueSummary)future.get());
                            List childRequirements = JIRARequirementsProvider.this.findChildrenFor(requirement, 0);
                            JIRARequirementsProvider.this.requirements.add(requirement.withChildren(childRequirements));
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        catch (ExecutionException e) {
                            e.printStackTrace();
                        }
                    }
                }, (Executor)MoreExecutors.sameThreadExecutor());
                future.addListener(new Runnable(){

                    @Override
                    public void run() {
                        JIRARequirementsProvider.this.queueSize.decrementAndGet();
                    }
                }, (Executor)this.executorService);
            }
            this.waitTillEmpty(this.queueSize);
            this.requirements = this.addParentsTo(this.requirements);
            this.persist(this.requirements);
        }
        return this.requirements;
    }

    private List<Requirement> persisted(List<Requirement> requirements) {
        if (requirements != null) {
            return requirements;
        }
        return null;
    }

    private void persist(List<Requirement> requirements) {
    }

    private boolean providerActivated() {
        return this.environmentVariables.getPropertyAsBoolean("thucydides.providers.jira-requirements-provider", true);
    }

    private List<Requirement> addParentsTo(List<Requirement> requirements) {
        return this.addParentsTo(requirements, null);
    }

    private List<Requirement> addParentsTo(List<Requirement> requirements, String parent) {
        ArrayList augmentedRequirements = Lists.newArrayList();
        for (Requirement requirement : requirements) {
            List<Requirement> children = requirement.hasChildren() ? this.addParentsTo(requirement.getChildren(), requirement.getName()) : this.NO_REQUIREMENTS;
            augmentedRequirements.add(requirement.withParent(parent).withChildren(children));
        }
        return augmentedRequirements;
    }

    private Requirement requirementFrom(IssueSummary issue) {
        Requirement baseRequirement = Requirement.named((String)issue.getSummary()).withOptionalCardNumber(issue.getKey()).withType(issue.getType()).withNarrative(this.narativeTextFrom(issue)).withReleaseVersions(issue.getFixVersions());
        for (String fieldName : this.definedCustomFields()) {
            if (!issue.customField(fieldName).isPresent()) continue;
            String value = ((CustomFieldCast)issue.customField(fieldName).get()).asString();
            String renderedValue = (String)issue.getRendered().customField(fieldName).get();
            baseRequirement = baseRequirement.withCustomField(fieldName).setTo(value, renderedValue);
        }
        return baseRequirement;
    }

    private String narativeTextFrom(IssueSummary issue) {
        Optional customFieldName = Optional.fromNullable((Object)this.environmentVariables.getProperty(JIRARequirementsConfiguration.JIRA_CUSTOM_NARRATIVE_FIELD.getName()));
        if (customFieldName.isPresent()) {
            return (String)this.customFieldNameFor(issue, (String)customFieldName.get()).or((Object)issue.getRendered().getDescription());
        }
        return issue.getRendered().getDescription();
    }

    private Optional<String> customFieldNameFor(IssueSummary issue, String customFieldName) {
        if (issue.customField(customFieldName).isPresent()) {
            return Optional.of((Object)((CustomFieldCast)issue.customField(customFieldName).get()).asString());
        }
        return Optional.absent();
    }

    private List<Requirement> findChildrenFor(Requirement parent, int level) {
        List children = null;
        try {
            this.logger.info("Loading child requirements for: " + parent.getName());
            children = this.jiraClient.findByJQL(this.childIssuesJQL(parent, level));
            this.logger.info("Loading child requirements for " + parent.getName() + " done: " + children.size());
        }
        catch (JSONException e) {
            this.logger.warn("No children found for requirement " + parent, (Throwable)e);
            return this.NO_REQUIREMENTS;
        }
        List<Requirement> childRequirements = Collections.synchronizedList(new ArrayList());
        for (IssueSummary childIssue : children) {
            Requirement childRequirement = this.requirementFrom(childIssue);
            if (this.moreRequirements(level)) {
                List<Requirement> grandChildren = this.findChildrenFor(childRequirement, level + 1);
                childRequirement = childRequirement.withChildren(grandChildren);
            }
            childRequirements.add(childRequirement);
        }
        return childRequirements;
    }

    private void waitTillEmpty(AtomicInteger counter) {
        while (counter.get() > 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private String childIssuesJQL(Requirement parent, int level) {
        String linkType = this.getRequirementsLinks().get(level);
        if (linkType.equals("Epic Link")) {
            return "'" + this.getRequirementsLinks().get(level) + "' = " + parent.getCardNumber();
        }
        return "issue in linkedIssues(" + parent.getCardNumber() + ",\"" + linkType + "\")";
    }

    private boolean moreRequirements(int level) {
        return level < this.getRequirementsLinks().size() - 1;
    }

    private String rootRequirementsJQL() {
        return "issuetype = " + this.getRootIssueType() + " and project=" + this.getProjectKey();
    }

    private String getRootIssueType() {
        return this.environmentVariables.getProperty((Enum)JIRARequirementsConfiguration.JIRA_ROOT_ISSUE_TYPE, "epic");
    }

    public Optional<Requirement> getParentRequirementOf(TestOutcome testOutcome) {
        this.logger.debug("Find parent requirement in JIRA for " + testOutcome.getTitle());
        List issueKeys = testOutcome.getIssueKeys();
        if (!issueKeys.isEmpty() && this.providerActivated()) {
            try {
                Optional parentIssue = this.jiraClient.findByKey((String)issueKeys.get(0));
                if (parentIssue.isPresent()) {
                    this.logger.debug("Parent found: " + parentIssue.get());
                    return Optional.of((Object)this.requirementFrom((IssueSummary)parentIssue.get()));
                }
                return Optional.absent();
            }
            catch (JSONException e) {
                if (this.noSuchIssue(e)) {
                    return Optional.absent();
                }
                throw new IllegalArgumentException(e);
            }
        }
        return Optional.absent();
    }

    private boolean noSuchIssue(JSONException e) {
        return e.getMessage().contains("error 400");
    }

    public Optional<Requirement> getRequirementFor(TestTag testTag) {
        for (Requirement requirement : this.getFlattenedRequirements()) {
            if (!requirement.getType().equals(testTag.getType()) || !requirement.getName().equals(testTag.getName())) continue;
            return Optional.of((Object)requirement);
        }
        return Optional.absent();
    }

    public Set<TestTag> getTagsFor(TestOutcome testOutcome) {
        List issues = testOutcome.getIssueKeys();
        HashSet tags = Sets.newHashSet();
        for (String issue : issues) {
            tags.addAll(this.tagsFromIssue(issue));
        }
        return ImmutableSet.copyOf((Collection)tags);
    }

    private Collection<? extends TestTag> tagsFromIssue(String issueKey) {
        if (this.providerActivated()) {
            IssueTagReader tagReader = new IssueTagReader(this.jiraClient, this.getFlattenedRequirements(), this.projectKey);
            return tagReader.addIssueTags(issueKey).addRequirementTags(issueKey).addVersionTags(issueKey).getTags();
        }
        return ImmutableList.of();
    }

    private List<Requirement> getFlattenedRequirements() {
        return this.getFlattenedRequirements(this.getRequirements());
    }

    private List<Requirement> getFlattenedRequirements(List<Requirement> someRequirements) {
        ArrayList flattenedRequirements = Lists.newArrayList();
        for (Requirement requirement : someRequirements) {
            flattenedRequirements.add(requirement);
            flattenedRequirements.addAll(this.getFlattenedRequirements(requirement.getChildren()));
        }
        return flattenedRequirements;
    }

    public List<String> getRequirementsLinks() {
        String requirementLinks = this.environmentVariables.getProperty(JIRARequirementsConfiguration.JIRA_REQUIREMENT_LINKS.getName(), "Epic Link");
        return Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)requirementLinks);
    }
}

