/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.plugins.jira.model;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;
import net.thucydides.plugins.jira.model.JIRACommentBuilder;
import net.thucydides.plugins.jira.model.NamedTestResult;

public class TestResultComment {
    private final String testRunNumber;
    private final SortedMap<String, NamedTestResult> namedTestResults;
    private final String reportUrl;
    private final boolean wikiRenderingActive;
    private static final int REPORT_URL_LINE = 1;
    private static final int TEXT_NUMBER_LINE = 2;
    private static final int FIRST_TEST_RESULT_LINE = 3;

    protected TestResultComment(String commentText) {
        ImmutableList commentLines = ImmutableList.copyOf((Object[])commentText.split("\\r?\\n"));
        this.reportUrl = this.findReportUrl((List<String>)commentLines);
        this.testRunNumber = this.findTestRunNumber((List<String>)commentLines);
        this.namedTestResults = this.findTestResults((List<String>)commentLines);
        this.wikiRenderingActive = true;
    }

    protected TestResultComment(String reportUrl, String testRunNumber, List<NamedTestResult> namedTestResults, boolean wikiRenderingActive) {
        this.reportUrl = reportUrl;
        this.testRunNumber = testRunNumber;
        this.namedTestResults = this.indexByTestName(namedTestResults);
        this.wikiRenderingActive = wikiRenderingActive;
    }

    public static JIRACommentBuilder comment(boolean wikiRenderingActive) {
        return new JIRACommentBuilder(wikiRenderingActive);
    }

    public static TestResultComment fromText(String commentText) {
        return new TestResultComment(commentText);
    }

    private SortedMap<String, NamedTestResult> findTestResults(List<String> commentLines) {
        List<String> testResultLines = this.linesStartingAtRowIn(commentLines, 3);
        List namedTestResults = Lambda.convert(testResultLines, this.toNamedTestResults());
        return this.indexByTestName(namedTestResults);
    }

    private SortedMap<String, NamedTestResult> indexByTestName(List<NamedTestResult> namedTestResults) {
        Map indexedTestResults = Lambda.index(namedTestResults, (Object)((NamedTestResult)Lambda.on(NamedTestResult.class)).getTestName());
        TreeMap sortedTestResults = Maps.newTreeMap();
        sortedTestResults.putAll(indexedTestResults);
        return sortedTestResults;
    }

    private List<String> linesStartingAtRowIn(List<String> commentLines, int startingIndex) {
        if (commentLines.size() >= startingIndex) {
            return commentLines.subList(startingIndex, commentLines.size());
        }
        return Collections.EMPTY_LIST;
    }

    private Converter<String, NamedTestResult> toNamedTestResults() {
        return new Converter<String, NamedTestResult>(){

            public NamedTestResult convert(String commentLine) {
                String testName = TestResultComment.this.stripInitialDash(TestResultComment.this.textBeforeColon(commentLine));
                TestResult result = TestResultComment.this.getTestResult(commentLine);
                return new NamedTestResult(testName, result);
            }
        };
    }

    private TestResult getTestResult(String commentLine) {
        try {
            return TestResult.valueOf((String)this.textAfterColon(commentLine));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return TestResult.UNDEFINED;
        }
    }

    private String stripInitialDash(String testResultText) {
        if (testResultText.trim().startsWith("-")) {
            return testResultText.trim().substring(2);
        }
        return testResultText.trim();
    }

    private String findTestRunNumber(List<String> commentLines) {
        if (commentLines.size() > 2) {
            return this.textAfterColon(commentLines.get(2));
        }
        return null;
    }

    private String findReportUrl(List<String> commentLines) {
        if (commentLines.size() > 1) {
            return this.reportUrlIn(commentLines.get(1));
        }
        return null;
    }

    private String reportUrlIn(String commentLine) {
        if (this.wikiFormatUrl(commentLine)) {
            return this.wikiFormattedUrl(commentLine);
        }
        return this.textAfterColon(commentLine);
    }

    private String wikiFormattedUrl(String commentLine) {
        int pipe = commentLine.indexOf("|");
        int endBracket = commentLine.indexOf("]");
        return commentLine.substring(pipe + 1, endBracket);
    }

    private boolean wikiFormatUrl(String commentLine) {
        return commentLine.contains("[");
    }

    public String getReportUrl() {
        return this.reportUrl;
    }

    private String textBeforeColon(String line) {
        String[] lineTokens = this.splitAtColon(line);
        return lineTokens[0].trim();
    }

    private String[] splitAtColon(String line) {
        return line.split(":", 3);
    }

    private String[] splitAtPipe(String line) {
        return line.split("|", 3);
    }

    private String textAfterColon(String line) {
        String[] lineTokens = this.splitAtColon(line);
        if (lineTokens.length >= 2) {
            return this.splitAtColon(line)[1].trim();
        }
        return null;
    }

    public String getTestRunNumber() {
        return this.testRunNumber;
    }

    public List<NamedTestResult> getNamedTestResults() {
        if (this.namedTestResults.isEmpty()) {
            return Lists.newArrayList();
        }
        return Lambda.convert(this.namedTestResults.entrySet(), this.fromMapEntriesToNamedTestResults());
    }

    private Converter<Map.Entry<String, NamedTestResult>, NamedTestResult> fromMapEntriesToNamedTestResults() {
        return new Converter<Map.Entry<String, NamedTestResult>, NamedTestResult>(){

            public NamedTestResult convert(Map.Entry<String, NamedTestResult> from) {
                return from.getValue();
            }
        };
    }

    public TestResult getOverallResult() {
        List testResults = Lambda.convert(this.namedTestResults, this.toTestResults());
        return TestResultList.of((List)testResults).getOverallResult();
    }

    private Converter<NamedTestResult, TestResult> toTestResults() {
        return new Converter<NamedTestResult, TestResult>(){

            public TestResult convert(NamedTestResult namedTestResult) {
                return namedTestResult.getTestResult();
            }
        };
    }

    public String asText() {
        return this.toString();
    }

    public String toString() {
        return TestResultComment.comment(this.wikiRenderingActive).withTestRun(this.testRunNumber).withReportUrl(this.reportUrl).withNamedResults(this.getNamedTestResults()).asText();
    }

    public TestResultComment withUpdatedTestResults(List<TestOutcome> newResults) {
        HashMap mergedTestResultsIndexedByName = Maps.newHashMap();
        mergedTestResultsIndexedByName.putAll(this.namedTestResults);
        List newTestResults = Lambda.convert(newResults, this.fromTestOutcomesToNamedTestResults());
        for (NamedTestResult testResult : newTestResults) {
            mergedTestResultsIndexedByName.put(testResult.getTestName(), testResult);
        }
        ArrayList mergedTestResults = Lists.newArrayList();
        mergedTestResults.addAll(mergedTestResultsIndexedByName.values());
        return TestResultComment.comment(this.wikiRenderingActive).withTestRun(this.testRunNumber).withReportUrl(this.reportUrl).withNamedResults(mergedTestResults).asComment();
    }

    private Converter<TestOutcome, NamedTestResult> fromTestOutcomesToNamedTestResults() {
        return new Converter<TestOutcome, NamedTestResult>(){

            public NamedTestResult convert(TestOutcome testOutcome) {
                return new NamedTestResult(testOutcome.getTitle(), testOutcome.getResult());
            }
        };
    }

    public TestResultComment withUpdatedReportUrl(String newReportUrl) {
        return new TestResultComment(newReportUrl, this.testRunNumber, this.getNamedTestResults(), this.wikiRenderingActive);
    }

    public TestResultComment withUpdatedTestRunNumber(String newTestRunNumber) {
        return new TestResultComment(this.reportUrl, newTestRunNumber, this.getNamedTestResults(), this.wikiRenderingActive);
    }

    public TestResultComment withWikiRendering(boolean isWikiRenderedActive) {
        return new TestResultComment(this.reportUrl, this.testRunNumber, this.getNamedTestResults(), isWikiRenderedActive);
    }
}

