/*
 * Decompiled with CFR 0.152.
 */
package net.sf.alchim.mojo.yuicompressor;

import java.io.File;
import java.util.List;
import net.sf.alchim.mojo.yuicompressor.ErrorReporter4Mojo;
import net.sf.alchim.mojo.yuicompressor.SourceFile;
import net.sf.retrotranslator.runtime.java.lang._Class;
import net.sf.retrotranslator.runtime.java.lang._Integer;
import net.sf.retrotranslator.runtime.java.lang._String;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MojoSupport
extends AbstractMojo {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private File sourceDirectory;
    private File warSourceDirectory;
    private File webappDirectory;
    private File outputDirectory;
    private List<Resource> resources;
    private List<String> excludes;
    protected MavenProject project;
    protected boolean jswarn;
    protected boolean failOnWarning;
    protected ErrorReporter4Mojo jsErrorReporter_;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (this.failOnWarning) {
                this.jswarn = true;
            }
            this.jsErrorReporter_ = new ErrorReporter4Mojo(this.getLog(), this.jswarn);
            this.beforeProcess();
            this.processDir(this.sourceDirectory, this.outputDirectory, null, null, true);
            for (Resource resource : this.resources) {
                File destRoot = this.outputDirectory;
                if (resource.getTargetPath() != null) {
                    destRoot = new File(this.outputDirectory, resource.getTargetPath());
                }
                this.processDir(new File(resource.getDirectory()), destRoot, resource.getIncludes(), resource.getExcludes(), true);
            }
            this.processDir(this.warSourceDirectory, this.webappDirectory, null, null, false);
            this.afterProcess();
            this.getLog().info((CharSequence)_String.format((String)"nb warnings: %d, nb errors: %d", (Object[])new Object[]{_Integer.valueOf((int)this.jsErrorReporter_.getWarningCnt()), _Integer.valueOf((int)this.jsErrorReporter_.getErrorCnt())}));
            if (this.failOnWarning && this.jsErrorReporter_.getWarningCnt() > 0) {
                throw new MojoFailureException(new StringBuffer("warnings on ").append(_Class.getSimpleName(((Object)((Object)this)).getClass())).append("=> failure ! (see log)").toString());
            }
        }
        catch (RuntimeException exc) {
            throw exc;
        }
        catch (MojoFailureException exc) {
            throw exc;
        }
        catch (MojoExecutionException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new MojoExecutionException(new StringBuffer("wrap: ").append(exc.getMessage()).toString(), exc);
        }
    }

    protected abstract String[] getDefaultIncludes() throws Exception;

    protected abstract void beforeProcess() throws Exception;

    protected abstract void afterProcess() throws Exception;

    protected void processDir(File srcRoot, File destRoot, List<String> srcIncludes, List<String> srcExcludes, boolean destAsSource) throws Exception {
        if (srcRoot == null || !srcRoot.exists()) {
            return;
        }
        if (destRoot == null) {
            throw new MojoFailureException(new StringBuffer("destination directory for ").append(srcRoot).append(" is null").toString());
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(srcRoot);
        if (srcIncludes != null && !srcIncludes.isEmpty()) {
            scanner.setIncludes(srcIncludes.toArray(EMPTY_STRING_ARRAY));
        } else {
            scanner.setIncludes(this.getDefaultIncludes());
        }
        if (srcExcludes != null && !srcExcludes.isEmpty()) {
            scanner.setExcludes(srcExcludes.toArray(EMPTY_STRING_ARRAY));
        }
        if (this.excludes != null && !this.excludes.isEmpty()) {
            scanner.setExcludes(this.excludes.toArray(EMPTY_STRING_ARRAY));
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        String[] stringArray = scanner.getIncludedFiles();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            SourceFile src = new SourceFile(srcRoot, destRoot, name, destAsSource);
            this.jsErrorReporter_.setDefaultFileName(new StringBuffer("...").append(src.toFile().getAbsolutePath().substring(this.project.getBasedir().getAbsolutePath().length())).toString());
            this.processFile(src);
            ++n2;
        }
    }

    protected abstract void processFile(SourceFile var1) throws Exception;
}

