/*
 * Decompiled with CFR 0.152.
 */
package net.sf.alchim.mojo.yuicompressor;

import java.io.File;
import junit.framework.TestCase;
import net.sf.alchim.mojo.yuicompressor.Aggregation;
import org.codehaus.plexus.util.FileUtils;

public class AggregationTestCase
extends TestCase {
    private File dir_;

    protected void setUp() throws Exception {
        this.dir_ = File.createTempFile(((Object)((Object)this)).getClass().getName(), "-test");
        this.dir_.delete();
        this.dir_.mkdirs();
    }

    protected void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)this.dir_);
    }

    public void test0to1() throws Exception {
        Aggregation target = new Aggregation();
        target.output = new File(this.dir_, "output.js");
        AggregationTestCase.assertFalse((boolean)target.output.exists());
        target.run();
        AggregationTestCase.assertFalse((boolean)target.output.exists());
        target.includes = new String[0];
        AggregationTestCase.assertFalse((boolean)target.output.exists());
        target.run();
        AggregationTestCase.assertFalse((boolean)target.output.exists());
        target.includes = new String[]{"**/*.js"};
        AggregationTestCase.assertFalse((boolean)target.output.exists());
        target.run();
        AggregationTestCase.assertFalse((boolean)target.output.exists());
    }

    public void test1to1() throws Exception {
        File f1 = new File(this.dir_, "01.js");
        FileUtils.fileWrite((String)f1.getAbsolutePath(), (String)"1");
        Aggregation target = new Aggregation();
        target.output = new File(this.dir_, "output.js");
        target.includes = new String[]{f1.getName()};
        AggregationTestCase.assertFalse((boolean)target.output.exists());
        target.run();
        AggregationTestCase.assertTrue((boolean)target.output.exists());
        AggregationTestCase.assertEquals((String)FileUtils.fileRead((File)f1), (String)FileUtils.fileRead((File)target.output));
    }

    public void test2to1() throws Exception {
        File f1 = new File(this.dir_, "01.js");
        FileUtils.fileWrite((String)f1.getAbsolutePath(), (String)"1");
        File f2 = new File(this.dir_, "02.js");
        FileUtils.fileWrite((String)f2.getAbsolutePath(), (String)"22\n22");
        Aggregation target = new Aggregation();
        target.output = new File(this.dir_, "output.js");
        target.includes = new String[]{f1.getName(), f2.getName()};
        AggregationTestCase.assertFalse((boolean)target.output.exists());
        target.run();
        AggregationTestCase.assertTrue((boolean)target.output.exists());
        AggregationTestCase.assertEquals((String)(String.valueOf(FileUtils.fileRead((File)f1)) + FileUtils.fileRead((File)f2)), (String)FileUtils.fileRead((File)target.output));
        target.output.delete();
        target.includes = new String[]{"*.js"};
        AggregationTestCase.assertFalse((boolean)target.output.exists());
        target.run();
        AggregationTestCase.assertTrue((boolean)target.output.exists());
        AggregationTestCase.assertEquals((String)(String.valueOf(FileUtils.fileRead((File)f1)) + FileUtils.fileRead((File)f2)), (String)FileUtils.fileRead((File)target.output));
    }

    public void testNoDuplicateAggregation() throws Exception {
        File f1 = new File(this.dir_, "01.js");
        FileUtils.fileWrite((String)f1.getAbsolutePath(), (String)"1");
        File f2 = new File(this.dir_, "02.js");
        FileUtils.fileWrite((String)f2.getAbsolutePath(), (String)"22\n22");
        Aggregation target = new Aggregation();
        target.output = new File(this.dir_, "output.js");
        target.includes = new String[]{f1.getName(), f1.getName(), f2.getName()};
        AggregationTestCase.assertFalse((boolean)target.output.exists());
        target.run();
        AggregationTestCase.assertTrue((boolean)target.output.exists());
        AggregationTestCase.assertEquals((String)(String.valueOf(FileUtils.fileRead((File)f1)) + FileUtils.fileRead((File)f2)), (String)FileUtils.fileRead((File)target.output));
        target.output.delete();
        target.includes = new String[]{f1.getName(), "*.js"};
        AggregationTestCase.assertFalse((boolean)target.output.exists());
        target.run();
        AggregationTestCase.assertTrue((boolean)target.output.exists());
        AggregationTestCase.assertEquals((String)(String.valueOf(FileUtils.fileRead((File)f1)) + FileUtils.fileRead((File)f2)), (String)FileUtils.fileRead((File)target.output));
    }

    public void test2to1Order() throws Exception {
        File f1 = new File(this.dir_, "01.js");
        FileUtils.fileWrite((String)f1.getAbsolutePath(), (String)"1");
        File f2 = new File(this.dir_, "02.js");
        FileUtils.fileWrite((String)f2.getAbsolutePath(), (String)"2");
        Aggregation target = new Aggregation();
        target.output = new File(this.dir_, "output.js");
        target.includes = new String[]{f2.getName(), f1.getName()};
        AggregationTestCase.assertFalse((boolean)target.output.exists());
        target.run();
        AggregationTestCase.assertTrue((boolean)target.output.exists());
        AggregationTestCase.assertEquals((String)(String.valueOf(FileUtils.fileRead((File)f2)) + FileUtils.fileRead((File)f1)), (String)FileUtils.fileRead((File)target.output));
    }

    public void test2to1WithNewLine() throws Exception {
        File f1 = new File(this.dir_, "01.js");
        FileUtils.fileWrite((String)f1.getAbsolutePath(), (String)"1");
        File f2 = new File(this.dir_, "02.js");
        FileUtils.fileWrite((String)f2.getAbsolutePath(), (String)"22\n22");
        Aggregation target = new Aggregation();
        target.output = new File(this.dir_, "output.js");
        target.insertNewLine = true;
        target.includes = new String[]{f1.getName(), f2.getName()};
        AggregationTestCase.assertFalse((boolean)target.output.exists());
        target.run();
        AggregationTestCase.assertTrue((boolean)target.output.exists());
        AggregationTestCase.assertEquals((String)(String.valueOf(FileUtils.fileRead((File)f1)) + "\n" + FileUtils.fileRead((File)f2) + "\n"), (String)FileUtils.fileRead((File)target.output));
    }

    public void testAbsolutePathFromInside() throws Exception {
        File f1 = new File(this.dir_, "01.js");
        FileUtils.fileWrite((String)f1.getAbsolutePath(), (String)"1");
        File f2 = new File(this.dir_, "02.js");
        FileUtils.fileWrite((String)f2.getAbsolutePath(), (String)"22\n22");
        Aggregation target = new Aggregation();
        target.output = new File(this.dir_, "output.js");
        target.includes = new String[]{f1.getAbsolutePath(), f2.getName()};
        AggregationTestCase.assertFalse((boolean)target.output.exists());
        target.run();
        AggregationTestCase.assertTrue((boolean)target.output.exists());
        AggregationTestCase.assertEquals((String)(String.valueOf(FileUtils.fileRead((File)f1)) + FileUtils.fileRead((File)f2)), (String)FileUtils.fileRead((File)target.output));
    }

    public void testAbsolutePathFromOutside() throws Exception {
        File f1 = File.createTempFile("test-01", ".js");
        try {
            FileUtils.fileWrite((String)f1.getAbsolutePath(), (String)"1");
            File f2 = new File(this.dir_, "02.js");
            FileUtils.fileWrite((String)f2.getAbsolutePath(), (String)"22\n22");
            Aggregation target = new Aggregation();
            target.output = new File(this.dir_, "output.js");
            target.includes = new String[]{f1.getAbsolutePath(), f2.getName()};
            AggregationTestCase.assertFalse((boolean)target.output.exists());
            target.run();
            AggregationTestCase.assertTrue((boolean)target.output.exists());
            AggregationTestCase.assertEquals((String)(String.valueOf(FileUtils.fileRead((File)f1)) + FileUtils.fileRead((File)f2)), (String)FileUtils.fileRead((File)target.output));
        }
        finally {
            f1.delete();
        }
    }
}

