/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.woff;

import java.io.IOException;
import org.mabb.fontverter.opentype.OpenTypeFont;
import org.mabb.fontverter.validator.RuleValidator;
import org.mabb.fontverter.validator.ValidateRule;
import org.mabb.fontverter.woff.Woff2Font;
import org.mabb.fontverter.woff.WoffTable;

public class Woff2Validator
extends RuleValidator<Woff2Font> {
    public Woff2Validator() {
        this.addRuleDefinition(new HeaderRules());
    }

    public static class HeaderRules {
        @ValidateRule(message="Reported total sfnt size not equal to calculated size")
        public String totalSfntSize(Woff2Font font) throws IOException {
            OpenTypeFont otfFOnt = (OpenTypeFont)font.getFonts().get(0);
            int reportedTotal = otfFOnt.getData().length;
            int total = 12 + font.getTables().size() * 16;
            for (WoffTable tableOn : font.getTables()) {
                total += this.round4(tableOn.originalLength);
            }
            if (reportedTotal != total) {
                return String.format("reported: %d != calc: %d", reportedTotal, total);
            }
            return "";
        }

        private int round4(int num) {
            if (num % 4 == 0) {
                return num;
            }
            return num + (4 - num % 4);
        }

        @ValidateRule(message="Header is not correct size")
        public String headerBytesCorrectSize(Woff2Font font) throws IOException {
            if (font.header.getData().length != 48) {
                return String.format("%d != 48", font.header.getData().length);
            }
            return "";
        }
    }
}

